/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.wkschanges;

import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges.EntityChangesProcessor;
import org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges.ModelChangesProcessor;

public class FileDeltaVisitor
implements IResourceDeltaVisitor {
    private static void log(String msg) {
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        FileDeltaVisitor.log("visit(delta)");
        if (this.isModelFile(delta)) {
            ModelChangesProcessor.processModelChange(delta);
            return false;
        }
        if (this.isEntityFile(delta)) {
            EntityChangesProcessor.processEntityChange(delta);
            return false;
        }
        return true;
    }

    private boolean isModelFile(IResourceDelta delta) {
        boolean result = false;
        String fullPath = delta.getFullPath().toString();
        FileDeltaVisitor.log("isModelFile(IResourceDelta delta) : fullPath = " + fullPath);
        if (fullPath != null && fullPath.endsWith(".model")) {
            result = true;
        }
        FileDeltaVisitor.log("isModelFile(IResourceDelta delta) : " + result);
        return result;
    }

    private boolean isEntityFile(IResourceDelta delta) {
        boolean result = false;
        String fullPath = delta.getFullPath().toString();
        FileDeltaVisitor.log("isEntityFile(IResourceDelta delta) : fullPath = " + fullPath);
        if (fullPath != null && fullPath.endsWith(".entity")) {
            result = true;
        }
        FileDeltaVisitor.log("isEntityFile(IResourceDelta delta) : " + result);
        return result;
    }
}

