/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.model;

import java.util.ArrayList;
import java.util.List;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.ContentAssistConfiguration;
import org.telosys.tools.eclipse.plugin.editors.velocity.model.VelocityKeyWord;

public class VelocityKeyWords {
    private static List<VelocityKeyWord> keyWords;
    private static String[] directives;

    static {
        directives = null;
    }

    public static String[] getAllDirectives() {
        if (directives == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (VelocityKeyWord keyWord : VelocityKeyWords.getKeyWords()) {
                list.add(keyWord.getValue());
            }
            directives = new String[list.size()];
            directives = list.toArray(directives);
        }
        return directives;
    }

    public static List<VelocityKeyWord> getKeyWords() {
        if (keyWords == null) {
            VelocityKeyWords.initKeyWords();
        }
        return keyWords;
    }

    private static String docHTML(String docId) {
        return ContentAssistConfiguration.getMessage(docId);
    }

    private static void initKeyWords() {
        keyWords = new ArrayList<VelocityKeyWord>();
        keyWords.add(new VelocityKeyWord("#assertFalse", "#assertFalse()", VelocityKeyWords.docHTML("directive.assertfalse.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#assertTrue", "#assertTrue()", VelocityKeyWords.docHTML("directive.asserttrue.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#break", "#break", VelocityKeyWords.docHTML("directive.break.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#checkId", "#checkId()", VelocityKeyWords.docHTML("directive.checkid.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#define", "#define()", VelocityKeyWords.docHTML("directive.define.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#else", "#else", null, "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#elseif", "#elseif()", null, "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#end", "#end", null, "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#error", "#error()", VelocityKeyWords.docHTML("directive.error.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#evaluate", "#evaluate()", VelocityKeyWords.docHTML("directive.evaluate.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#foreach", "#foreach()", VelocityKeyWords.docHTML("directive.foreach.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#if", "#if()", VelocityKeyWords.docHTML("directive.if.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#include", "#include()", VelocityKeyWords.docHTML("directive.include.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#macro", "#macro()", VelocityKeyWords.docHTML("directive.macro.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#parse", "#parse()", VelocityKeyWords.docHTML("directive.parse.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#set", "#set()", VelocityKeyWords.docHTML("directive.set.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#stop", "#stop", VelocityKeyWords.docHTML("directive.stop.doc"), "VELOCITY_DIRECTIVE"));
        keyWords.add(new VelocityKeyWord("#using", "#using()", VelocityKeyWords.docHTML("directive.using.doc"), "VELOCITY_DIRECTIVE"));
    }
}

