/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.HtmlCompletionProposal;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.TelosysGeneratorObjectInfo;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.VelocityKeyWordProvider;
import org.telosys.tools.eclipse.plugin.editors.velocity.model.VelocityKeyWord;

public class VelocityContentAssistProcessor
implements IContentAssistProcessor {
    private VelocityKeyWordProvider wordProvider;
    private String lastError;
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];

    public VelocityContentAssistProcessor() {
        this.wordProvider = new VelocityKeyWordProvider(new TelosysGeneratorObjectInfo());
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentOffset) {
        ICompletionProposal[] proposals = this.NO_COMPLETIONS;
        try {
            String context = this.extractPrefix(textViewer, documentOffset);
            List<Object> suggestions = new ArrayList();
            if (!context.isEmpty() && context.contains(".")) {
                if (context.charAt(context.length() - 1) == '.' && context.charAt(0) != '$') {
                    proposals = this.NO_COMPLETIONS;
                } else if (context.charAt(0) == '$' && context.contains(".")) {
                    String variableName = this.extractBeanName(context);
                    if (context.charAt(context.length() - 1) == '.') {
                        suggestions = this.wordProvider.suggestContextVariableOutline(variableName, null);
                    } else {
                        String filter = this.extractMethodNameFilter(context);
                        suggestions = this.wordProvider.suggestContextVariableOutline(variableName, filter);
                    }
                }
            } else {
                suggestions = this.wordProvider.suggest(context);
            }
            proposals = this.buildResult(suggestions, context, documentOffset - context.length());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lastError = e.getMessage();
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer arg0, int arg1) {
        this.lastError = "No Context Information available";
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public String getErrorMessage() {
        return this.lastError;
    }

    private ICompletionProposal[] buildResult(List<VelocityKeyWord> suggestions, String replacedWord, int offset) throws Exception {
        ICompletionProposal[] proposals = new ICompletionProposal[suggestions.size()];
        int index = 0;
        for (VelocityKeyWord suggestion : suggestions) {
            StringBuilder replacementText = new StringBuilder();
            if (replacedWord.contains(".")) {
                String preserveInput = replacedWord.substring(0, replacedWord.indexOf(".") + 1);
                replacementText.append(preserveInput).append(suggestion.getDisplayValue());
            } else if (replacedWord.startsWith("${")) {
                replacementText.append(suggestion.getDisplayValue().charAt(0));
                replacementText.append("{");
                replacementText.append(suggestion.getDisplayValue().substring(1, suggestion.getDisplayValue().length()));
            } else {
                replacementText.append(suggestion.getDisplayValue());
            }
            int cursorPosition = replacementText.length();
            if (suggestion.getDisplayValue().endsWith(")")) {
                cursorPosition = replacementText.length() - 1;
            }
            HtmlCompletionProposal cp = new HtmlCompletionProposal(replacementText.toString(), offset, replacedWord.length(), cursorPosition, PluginImages.getImage(suggestion.getCompletionIconName()), suggestion.getDisplayValue(), null, suggestion.getAdditionnalDocumentation());
            proposals[index] = cp;
            ++index;
        }
        return proposals;
    }

    private String extractPrefix(ITextViewer textViewer, int documentOffset) throws Exception {
        char currChar;
        IDocument document = textViewer.getDocument();
        int currOffset = documentOffset - 1;
        String currWord = "";
        while (currOffset >= 0 && !Character.isWhitespace(currChar = document.getChar(currOffset)) && currChar != ';') {
            currWord = String.valueOf(currChar) + currWord;
            --currOffset;
        }
        if (currWord.endsWith("(")) {
            currWord = "";
        } else {
            int startDirectiveIndex = currWord.lastIndexOf("#");
            int startBeanIndex = currWord.lastIndexOf("$");
            if (startBeanIndex != -1 || startDirectiveIndex != -1) {
                int startCurrentWord = startBeanIndex > startDirectiveIndex ? startBeanIndex : startDirectiveIndex;
                currWord = currWord.substring(startCurrentWord, currWord.length());
            }
        }
        return currWord;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private String extractBeanName(String context) {
        int pointPosition = context.indexOf(".");
        String formattedName = context.substring(1, pointPosition);
        if (formattedName.startsWith("{")) {
            formattedName = formattedName.substring(1, formattedName.length());
        }
        return formattedName;
    }

    private String extractMethodNameFilter(String context) {
        int pointPosition = context.indexOf(".");
        return context.substring(pointPosition + 1, context.length());
    }
}

