/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.ContextInfo;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.IContextObjectInfo;
import org.telosys.tools.eclipse.plugin.editors.velocity.model.VelocityKeyWord;
import org.telosys.tools.generator.context.doc.tooling.MethodInfo;

public class TelosysGeneratorObjectInfo
implements IContextObjectInfo {
    private ContextInfo contextInfo = new ContextInfo();
    private List<VelocityKeyWord> predefVariables;
    private List<VelocityKeyWord> objectNames;
    private Map<String, List<VelocityKeyWord>> beansInfos = new HashMap<String, List<VelocityKeyWord>>();

    @Override
    public List<VelocityKeyWord> getPredefineVariables() {
        ArrayList<VelocityKeyWord> variables = new ArrayList();
        if (this.predefVariables == null) {
            String[] names = this.contextInfo.getVariableNames();
            if (names != null) {
                int i = 0;
                while (i < names.length) {
                    String displayValue = "$" + names[i];
                    variables.add(new VelocityKeyWord(names[i], displayValue, null, "VELOCITY_PREDEF_VARIABLE"));
                    ++i;
                }
                this.predefVariables = variables;
            }
        } else {
            variables = this.predefVariables;
        }
        return variables;
    }

    @Override
    public List<VelocityKeyWord> getContextBeans() {
        ArrayList<VelocityKeyWord> objects = new ArrayList<VelocityKeyWord>();
        if (this.objectNames == null) {
            objects.addAll(this.initializeBeansKeywords(this.contextInfo.getObjectNames(), "VELOCITY_BEAN_GENERATOR"));
            objects.addAll(this.initializeBeansKeywords(this.contextInfo.getPredefinedNames(), "VELOCITY_PREDEFNAMES"));
            Collections.sort(objects);
            this.objectNames = objects;
        } else {
            objects = this.objectNames;
        }
        return objects;
    }

    @Override
    public List<VelocityKeyWord> getBeanInfo(String objectName) {
        ArrayList<VelocityKeyWord> infos = new ArrayList();
        if (this.beansInfos.containsKey(objectName)) {
            infos = this.beansInfos.get(objectName);
        } else {
            MethodInfo[] methodsInfo = this.contextInfo.getAllMethodsInfo(objectName);
            if (methodsInfo != null) {
                int i = 0;
                while (i < methodsInfo.length) {
                    String imageName;
                    StringBuilder displayName = new StringBuilder();
                    displayName.append(methodsInfo[i].getVelocityName());
                    if (methodsInfo[i].isAttributeLike()) {
                        imageName = "VELOCITY_BEAN_PROPERTY";
                    } else {
                        displayName.append("()");
                        imageName = "VELOCITY_BEAN_METHOD";
                    }
                    String doc = this.contextInfo.getMethodDocumentation(objectName, methodsInfo[i].getSignature());
                    infos.add(new VelocityKeyWord(methodsInfo[i].getVelocityName(), displayName.toString(), doc, imageName));
                    ++i;
                }
                this.beansInfos.put(objectName, infos);
            }
        }
        return infos;
    }

    private List<VelocityKeyWord> initializeBeansKeywords(String[] objects, String iconKeyName) {
        ArrayList<VelocityKeyWord> keywords = new ArrayList<VelocityKeyWord>();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                String displayValue = "$" + objects[i];
                String doc = this.contextInfo.getClassDocumentation(objects[i]);
                keywords.add(new VelocityKeyWord(objects[i], displayValue, doc, iconKeyName));
                ++i;
            }
        }
        return keywords;
    }
}

