/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.contentassist;

import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class HtmlCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension3 {
    private String replacementString;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private String displayString;
    private IContextInformation contextInformation;
    private String additionalProposalInfo;
    private static final String FONT_SIZE = "2.5";

    public HtmlCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = this.formatDocumentationHTML(additionalProposalInfo);
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                BrowserInformationControl browser = new BrowserInformationControl(parent, null, false);
                return browser;
            }
        };
    }

    public int getPrefixCompletionStart(IDocument arg0, int arg1) {
        return 0;
    }

    public CharSequence getPrefixCompletionText(IDocument arg0, int arg1) {
        return null;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public Image getImage() {
        return this.image;
    }

    public Point getSelection(IDocument arg0) {
        return new Point(this.replacementOffset + this.cursorPosition, 0);
    }

    private String formatDocumentationHTML(String doc) {
        String formattedDoc = "";
        if (doc != null) {
            formattedDoc = "<font size=\"2.5\">" + doc + "</font>";
        }
        return formattedDoc;
    }
}

