/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.contentassist;

import java.util.HashMap;
import java.util.Map;
import org.telosys.tools.generator.context.doc.tooling.ClassInfo;
import org.telosys.tools.generator.context.doc.tooling.MethodInfo;
import org.telosys.tools.generator.context.doc.tooling.MethodParameter;

public class EditorDoc {
    Map<String, String> classDoc = new HashMap<String, String>();
    Map<String, String> methodsDoc = new HashMap<String, String>();

    private String buildKey(ClassInfo classInfo, MethodInfo methodInfo) {
        return String.valueOf(classInfo.getContextName()) + "." + methodInfo.getSignature();
    }

    public String getClassDoc(ClassInfo classInfo) {
        String name = classInfo.getContextName();
        String doc = this.classDoc.get(name);
        if (doc == null) {
            doc = this.buildHtmlClassDoc(classInfo);
            this.classDoc.put(name, doc);
        }
        return doc;
    }

    public String getMethodDoc(ClassInfo classInfo, MethodInfo methodInfo) {
        String key = this.buildKey(classInfo, methodInfo);
        String doc = this.methodsDoc.get(key);
        if (doc == null) {
            doc = this.buildHtmlMethodDoc(classInfo, methodInfo);
            this.classDoc.put(key, doc);
        }
        return doc;
    }

    private String buildHtmlClassDoc(ClassInfo classInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        String[] stringArray = classInfo.getDocText();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(String.valueOf(s) + "<br>");
            ++n2;
        }
        sb.append("<br>");
        if (classInfo.getSince() != null && classInfo.getSince().trim().length() > 0) {
            sb.append("Since : " + classInfo.getSince() + "<br>");
        }
        if (classInfo.isDeprecated()) {
            sb.append("<b>DEPRECATED (!) <b><br>");
        }
        sb.append("</p>");
        return sb.toString();
    }

    private String buildHtmlMethodDoc(ClassInfo classInfo, MethodInfo methodInfo) {
        String s;
        StringBuilder sb = new StringBuilder();
        sb.append("<CODE> <B>." + methodInfo.getSimpleDescription() + "</B> </CODE>");
        sb.append("<p>");
        if (methodInfo.isDeprecated()) {
            sb.append("<b>Deprecated.</b><br>");
            sb.append("<br>");
        }
        String[] stringArray = methodInfo.getDocText();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            sb.append(String.valueOf(s) + "<br>");
            ++n2;
        }
        if (methodInfo.hasParameters()) {
            sb.append("<br>");
            sb.append("<b>Parameters : </b><br>");
            for (MethodParameter p : methodInfo.getParameters()) {
                sb.append("&nbsp;&nbsp;&nbsp;<b>" + p.getName() + "</b> : " + p.getDescription() + "<br>");
            }
        }
        if (methodInfo.hasExampleText()) {
            sb.append("<br>");
            sb.append("<b>Example : </b><br>");
            sb.append("<code>");
            stringArray = methodInfo.getExampleText();
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                s = stringArray[n3];
                sb.append("&nbsp;&nbsp;&nbsp;" + s + "<br>");
                ++n3;
            }
            sb.append("</code>");
        }
        if (methodInfo.hasSince()) {
            sb.append("<br>");
            sb.append("<b>Since : </b>" + methodInfo.getSince() + "<br>");
        }
        sb.append("</p>");
        return sb.toString();
    }
}

