/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.contentassist;

import java.util.List;
import java.util.Map;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.EditorDoc;
import org.telosys.tools.generator.context.doc.tooling.ClassInfo;
import org.telosys.tools.generator.context.doc.tooling.DocBuilder;
import org.telosys.tools.generator.context.doc.tooling.MethodInfo;
import org.telosys.tools.generator.context.names.ContextNames;

public class ContextInfo {
    private static final MethodInfo[] VOID_METHOD_INFO_ARRAY = new MethodInfo[0];
    private final Map<String, ClassInfo> classesInfo;
    private final EditorDoc editorDoc;

    public ContextInfo() {
        DocBuilder docBuilder = new DocBuilder();
        this.classesInfo = docBuilder.getVelocityClassesInfo();
        this.editorDoc = new EditorDoc();
    }

    public String[] getVariableNames() {
        return ContextNames.getVariableNames();
    }

    public String[] getObjectNames() {
        return ContextNames.getObjectNames();
    }

    public String[] getPredefinedNames() {
        return ContextNames.getPredefinedNames();
    }

    public String[] getObjectAndVariableNames() {
        return ContextNames.getObjectAndVariableNames();
    }

    public ClassInfo getClassInfo(String objectName) {
        ClassInfo classInfo = this.classesInfo.get(objectName);
        return classInfo;
    }

    public MethodInfo getMethodInfo(String objectName, String methodSignature) {
        ClassInfo classInfo = this.classesInfo.get(objectName);
        if (classInfo != null) {
            return classInfo.getMethodInfo(methodSignature);
        }
        return null;
    }

    public MethodInfo[] getAllMethodsInfo(String objectName) {
        ClassInfo classInfo = this.classesInfo.get(objectName);
        if (classInfo != null) {
            List list = classInfo.getMethodsInfo();
            return list.toArray(VOID_METHOD_INFO_ARRAY);
        }
        return null;
    }

    public String getClassDocumentation(String objectName) {
        ClassInfo classInfo = this.classesInfo.get(objectName);
        if (classInfo != null) {
            return this.editorDoc.getClassDoc(classInfo);
        }
        return null;
    }

    public String getMethodDocumentation(String objectName, String methodSignature) {
        ClassInfo classInfo = this.classesInfo.get(objectName);
        if (classInfo != null) {
            MethodInfo methodInfo = classInfo.getMethodInfo(methodSignature);
            if (methodInfo != null) {
                return this.editorDoc.getMethodDoc(classInfo, methodInfo);
            }
            return null;
        }
        return null;
    }
}

