/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges.tasks;

import java.io.File;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dsl.commons.ModelLoadingResult;
import org.telosys.tools.eclipse.plugin.editors.dsl.commons.ModelManager;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditor;
import org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges.ModelEditorFinder;

public class ReloadModelTask
implements Runnable {
    private final File modelFile;

    private static void log(String msg) {
        PluginLogger.debug("ReloadModelTask : " + msg);
    }

    public ReloadModelTask(File modelFile) {
        this.modelFile = modelFile;
        ReloadModelTask.log("TASK created");
    }

    @Override
    public void run() {
        ReloadModelTask.log("TASK run()...");
        if (this.modelFile.exists()) {
            ReloadModelTask.log(" The model file exists : " + this.modelFile.getName());
            ModelLoadingResult r = ModelManager.load(this.modelFile);
            ModelEditor modelEditor = ModelEditorFinder.findModelEditorForModelFile(this.modelFile);
            if (modelEditor != null) {
                ReloadModelTask.log(" ModelEditor instance found for file : " + this.modelFile.getName());
                ReloadModelTask.log(" Calling the ModelEditor refresh() method ...");
                modelEditor.updateEditor(r);
            } else {
                ReloadModelTask.log(" No ModelEditor for this file : " + this.modelFile.getName());
            }
        } else {
            ReloadModelTask.log(" The model file doesn't exist (deleted) : " + this.modelFile.getName());
        }
    }
}

