/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.swt.widgets.Display;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges.RefreshWorkspaceFolderJob;
import org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges.tasks.CloseModelEditorTask;

public class ModelChangesProcessor {
    private static void log(String msg) {
        PluginLogger.log(ModelChangesProcessor.class, msg);
    }

    public static void processModelChange(IResourceDelta delta) {
        ModelChangesProcessor.log("processModelChange(delta)");
        switch (delta.getKind()) {
            case 1: {
                ModelChangesProcessor.modelFileAdded(delta);
                break;
            }
            case 2: {
                ModelChangesProcessor.modelFileRemoved(delta);
                break;
            }
            case 4: {
                ModelChangesProcessor.modelFileChanged(delta);
            }
        }
    }

    private static void modelFileAdded(IResourceDelta delta) {
        ModelChangesProcessor.log("MODEL ADDED (nothing to do) : " + delta.getResource().getFullPath());
    }

    private static void modelFileChanged(IResourceDelta delta) {
        ModelChangesProcessor.log("MODEL CHANGED (nothing to do) : " + delta.getResource().getFullPath());
    }

    private static void modelFileRemoved(IResourceDelta delta) {
        IResource res = delta.getResource();
        ModelChangesProcessor.log("MODEL REMOVED : " + res.getFullPath());
        File modelFile = EclipseWksUtil.toFile((IFile)delta.getResource());
        ModelChangesProcessor.log("modelFile.getAbsolutePath() = " + modelFile.getAbsolutePath());
        DslModelUtil.deleteModel((File)modelFile);
        ModelChangesProcessor.log("Model file and folder deleted.");
        RefreshWorkspaceFolderJob refreshWorkspaceJob = new RefreshWorkspaceFolderJob(modelFile.getParentFile());
        refreshWorkspaceJob.schedule();
        ModelChangesProcessor.log("refreshWorkspaceJob.schedule() done.");
        ModelChangesProcessor.closeModelEditor(modelFile);
    }

    private static void closeModelEditor(File modelFile) {
        ModelChangesProcessor.log("closeModelEditor()");
        Display.getDefault().asyncExec((Runnable)new CloseModelEditorTask(modelFile));
    }
}

