/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dsl.wkschanges.tasks.ReloadModelTask;

public class EntityChangesProcessor {
    private static void log(String msg) {
        PluginLogger.log(EntityChangesProcessor.class, msg);
    }

    public static void processEntityChange(IResourceDelta delta) throws CoreException {
        EntityChangesProcessor.log("processEntityChange(delta)");
        switch (delta.getKind()) {
            case 1: {
                EntityChangesProcessor.entityFileAdded(delta);
                break;
            }
            case 2: {
                EntityChangesProcessor.entityFileRemoved(delta);
                break;
            }
            case 4: {
                EntityChangesProcessor.entityFileChanged(delta);
            }
        }
    }

    private static void entityFileAdded(IResourceDelta delta) throws CoreException {
        IResource res = delta.getResource();
        EntityChangesProcessor.log("ENTITY ADDED : " + res.getFullPath());
        EntityChangesProcessor.processEntity(res);
    }

    private static void entityFileRemoved(IResourceDelta delta) throws CoreException {
        IResource res = delta.getResource();
        EntityChangesProcessor.log("ENTITY REMOVED : " + res.getFullPath());
        EntityChangesProcessor.processEntity(res);
    }

    private static void entityFileChanged(IResourceDelta delta) throws CoreException {
        IResource res = delta.getResource();
        EntityChangesProcessor.log("ENTITY CHANGED : " + res.getFullPath());
        int flags = delta.getFlags();
        if ((flags & 0x100) != 0) {
            EntityChangesProcessor.log("--> Content Change");
            EntityChangesProcessor.processEntity(res);
        }
        if ((flags & 0x40000) != 0) {
            EntityChangesProcessor.log("--> Content Replaced");
            EntityChangesProcessor.processEntity(res);
        }
    }

    private static void processEntity(IResource resource) throws CoreException {
        File modelFile;
        File entityFile = EntityChangesProcessor.getFile(resource);
        if (entityFile != null && (modelFile = DslModelUtil.getModelFileForEntityFile((File)entityFile)) != null) {
            EntityChangesProcessor.reloadModel(modelFile);
        }
    }

    private static File getFile(IResource resource) {
        if (resource instanceof IFile) {
            IFile iFile = (IFile)resource;
            return EclipseWksUtil.toFile(iFile);
        }
        return null;
    }

    private static void reloadModel(File modelFile) {
        if (modelFile.exists()) {
            EntityChangesProcessor.log(" The model file exists ( it can be reloaded ): " + modelFile.getName());
            Display.getDefault().asyncExec((Runnable)new ReloadModelTask(modelFile));
        } else {
            EntityChangesProcessor.log(" The model file deosn't exist ( it cannot be parsed => no refresh ): " + modelFile.getName());
        }
    }
}

