/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.model;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditorPageModelEntities;

public class TableContextMenuListener
implements Listener {
    public static final int NEW = 1;
    public static final int OPEN = 2;
    public static final int RENAME = 3;
    public static final int DELETE = 4;
    private final int action;
    private final ModelEditorPageModelEntities entitiesPage;

    public TableContextMenuListener(ModelEditorPageModelEntities entitiesPage, int action) {
        this.action = action;
        this.entitiesPage = entitiesPage;
    }

    public void handleEvent(Event event) {
        TableItem selectedItem = this.entitiesPage.getSelectedTableItem();
        String entityAbsoluteFilePath = (String)selectedItem.getData();
        switch (this.action) {
            case 1: {
                this.doNew(entityAbsoluteFilePath);
                break;
            }
            case 2: {
                this.doOpen(entityAbsoluteFilePath);
                break;
            }
            case 3: {
                this.doRename(entityAbsoluteFilePath);
                break;
            }
            case 4: {
                this.doDelete(entityAbsoluteFilePath);
            }
        }
    }

    private void doNew(String entityAbsoluteFilePath) {
        this.entitiesPage.doNewEntity();
    }

    private void doOpen(String entityAbsoluteFilePath) {
        this.entitiesPage.doOpenEntityInEditor(entityAbsoluteFilePath);
    }

    private void doRename(String entityAbsoluteFilePath) {
        this.entitiesPage.doRenameEntity(entityAbsoluteFilePath);
    }

    private void doDelete(String entityAbsoluteFilePath) {
        this.entitiesPage.doDeleteEntity(entityAbsoluteFilePath);
    }
}

