/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.model;

import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.telosys.tools.dsl.DslModelManager;
import org.telosys.tools.dsl.parser.model.DomainModelInfo;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditor;
import org.telosys.tools.eclipse.plugin.editors.dsl.commons.ModelLoadingResult;
import org.telosys.tools.eclipse.plugin.editors.dsl.commons.ModelManager;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditorPageCodeGeneration;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditorPageModelEntities;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditorPageModelInfo;
import org.telosys.tools.generic.model.Model;

public class ModelEditor
extends AbstractModelEditor {
    private Image _imageWithoutError = null;
    private ModelEditorPageModelEntities _modelEntitiesPage;
    private ModelEditorPageModelInfo _modelInformationPage;
    private ModelEditorPageCodeGeneration _codeGenerationPage;
    private ModelLoadingResult _modelLoadingResult = null;

    public ModelLoadingResult getModelLoadingResult() {
        return this._modelLoadingResult;
    }

    public DomainModelInfo getDomainModelInfo() {
        if (this._modelLoadingResult != null) {
            return this._modelLoadingResult.getModelInfo();
        }
        return null;
    }

    public void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.log((Object)this, "--- DSL MODEL EDITOR INIT ");
        this.log((Object)this, "init(..,..) : site id = '" + site.getId() + "'");
        this.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
        ImageDescriptor imageDescriptor = input.getImageDescriptor();
        if (imageDescriptor != null) {
            this._imageWithoutError = imageDescriptor.createImage();
        }
        this.loadModel();
    }

    public void dispose() {
        super.dispose();
        this._imageWithoutError.dispose();
    }

    protected void addPages() {
        this.log((Object)this, "addPages()...");
        this._modelEntitiesPage = new ModelEditorPageModelEntities(this, "ModelEditorPage1", " Model entities ");
        this._modelInformationPage = new ModelEditorPageModelInfo(this, "ModelEditorPage2", " Model information ");
        this._codeGenerationPage = new ModelEditorPageCodeGeneration(this, "ModelEditorPage3", " Code generation ");
        try {
            this.addPage((IFormPage)this._modelEntitiesPage);
            this.addPage((IFormPage)this._modelInformationPage);
            this.addPage((IFormPage)this._codeGenerationPage);
        }
        catch (PartInitException e) {
            MsgBox.error("RepositoryEditor : addPage(page) throws PartInitException ", e);
        }
        this.setCodeGenerationPage(this._codeGenerationPage);
        this.log((Object)this, "addPages() : DONE");
    }

    @Override
    protected Model loadModel(File modelFile) {
        this._modelLoadingResult = ModelManager.load(modelFile);
        return this._modelLoadingResult.getModel();
    }

    public void updateEditor(ModelLoadingResult r) {
        this._modelLoadingResult = r;
        if (r.getEntitiesErrors() != null && !r.getEntitiesErrors().isEmpty()) {
            Image errorImage = PluginImages.getImage("ERROR");
            this.log((Object)this, "refresh() : setTitleImage(errorImage) ");
            this.setTitleImage(errorImage);
        } else {
            this.setTitleImage(this._imageWithoutError);
        }
        this._modelEntitiesPage.populateEntities();
        this.setModel(r.getModel());
    }

    @Override
    protected void saveModel(Model model, File modelFile) {
        if (this._modelInformationPage != null) {
            DomainModelInfo _modelInfo = this.getDomainModelInfo();
            if (_modelInfo != null) {
                this._modelInformationPage.updateModelInformation(_modelInfo);
                DslModelManager modelManager = new DslModelManager();
                modelManager.saveModelInformation(modelFile, _modelInfo);
            } else {
                MsgBox.error("ModelInfo is null in the editor !");
            }
        } else {
            MsgBox.error("_modelInformationPage is null in the editor !");
        }
    }

    public void refresh() {
        this.log((Object)this, "refresh()...");
        this.loadModel();
        this.updateEditor(this._modelLoadingResult);
    }
}

