/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.scanner;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.EntityEditorColorManager;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.EntityEditorUtil;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.scanner.EntityEditorTokens;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.scanner.EntityWhitespaceDetector;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.scanner.FieldAnnotationWordDetector;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.scanner.FirstCharLowerCaseWordDetector;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.scanner.FirstCharUpperCaseWordDetector;

public class EntityEditorScanner
extends RuleBasedScanner {
    private static void log(String msg) {
    }

    public EntityEditorScanner(EntityEditorColorManager manager) {
        EntityEditorScanner.log("Constructor()...");
        ArrayList<Object> rulesList = new ArrayList<Object>();
        rulesList.add(new WhitespaceRule((IWhitespaceDetector)new EntityWhitespaceDetector()));
        rulesList.add(new EndOfLineRule("//", EntityEditorTokens.COMMENT_TOKEN));
        WordRule annotationRule = new WordRule((IWordDetector)new FieldAnnotationWordDetector(), EntityEditorTokens.DEFAULT_TOKEN);
        String[] stringArray = EntityEditorUtil.getAnnotations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            annotationRule.addWord(word, EntityEditorTokens.ANNOTATION_TOKEN);
            ++n2;
        }
        rulesList.add(annotationRule);
        rulesList.add(new SingleLineRule("(", ")", EntityEditorTokens.ANNOTATION_TOKEN));
        WordRule entityNameRule = new WordRule((IWordDetector)new FirstCharUpperCaseWordDetector(), EntityEditorTokens.ENTITY_NAME_TOKEN);
        rulesList.add(entityNameRule);
        WordRule wordRuleFirstCharLowerCase = new WordRule((IWordDetector)new FirstCharLowerCaseWordDetector(), EntityEditorTokens.DEFAULT_TOKEN);
        String[] stringArray2 = EntityEditorUtil.getEntityFieldTypes();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String str = stringArray2[n4];
            wordRuleFirstCharLowerCase.addWord(str, EntityEditorTokens.FIELD_TYPE_TOKEN);
            ++n4;
        }
        rulesList.add(wordRuleFirstCharLowerCase);
        IRule[] rulesArray = rulesList.toArray(new IRule[0]);
        this.setRules(rulesArray);
    }
}

