/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.EntityEditorUtil;

public class SuggestionsForAttributeType {
    protected static List<String> getSuggestions(String beginningOfWord) {
        ArrayList<String> suggestions = new ArrayList<String>();
        String[] stringArray = EntityEditorUtil.getEntityFieldTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.startsWith(beginningOfWord)) {
                suggestions.add(String.valueOf(type) + " ");
            }
            ++n2;
        }
        for (String entityName : SuggestionsForAttributeType.getListOfDefinedEntities()) {
            if (!entityName.startsWith(beginningOfWord)) continue;
            suggestions.add(String.valueOf(entityName) + " ");
        }
        return suggestions;
    }

    private static List<String> getListOfDefinedEntities() {
        ArrayList<String> fileList = new ArrayList<String>();
        FilenameFilter entitiesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String fileName) {
                return fileName.endsWith(".entity");
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        IEditorInput input = editor.getEditorInput();
        IPath path = ((FileEditorInput)input).getPath();
        File currentFolder = new File(path.toFile().getParent());
        String[] stringArray = currentFolder.list(entitiesFilter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            str = str.replace(".entity", "");
            str = String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
            fileList.add(str);
            ++n2;
        }
        return fileList;
    }
}

