/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.ProposalContext;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.SuggestionsForAttributeAnnotation;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.SuggestionsForAttributeType;

public class ProposalsManager {
    private void debug(String msg) {
        PluginLogger.debug(msg);
    }

    public ICompletionProposal[] getCompletionProposals(ITextViewer textViewer, int documentOffset) {
        IDocument document = textViewer.getDocument();
        this.debug("getCompletionProposals()...");
        ProposalContext ctx = this.getProposalContext(document, documentOffset);
        this.debug("getCompletionProposals() : ProposalContext : " + ctx);
        List<String> suggestions = null;
        switch (ctx.getProposalType()) {
            case ENTITY_ANNOTATION: {
                return null;
            }
            case ATTRIBUTE_ANNOTATION: {
                suggestions = SuggestionsForAttributeAnnotation.getSuggestions(ctx.getWord());
                break;
            }
            case ATTRIBUTE_TYPE: {
                suggestions = SuggestionsForAttributeType.getSuggestions(ctx.getWord());
                break;
            }
            default: {
                return null;
            }
        }
        if (suggestions != null && suggestions.size() > 0) {
            String originalWord = ctx.getWord();
            int originalWordOffset = documentOffset - originalWord.length();
            return this.buildProposals(suggestions, originalWord, originalWordOffset);
        }
        return null;
    }

    private ProposalContext getProposalContext(IDocument document, int documentOffset) {
        char c;
        boolean wordCompleted = false;
        boolean colonFound = false;
        boolean openBraceFound = false;
        StringBuffer sb = new StringBuffer();
        int pos = documentOffset;
        while ((c = this.getChar(document, --pos)) > '\u0000') {
            if (this.isWordChar(c)) {
                if (!wordCompleted) {
                    sb.append(c);
                }
            } else {
                wordCompleted = true;
            }
            if (c == '{') {
                openBraceFound = true;
            }
            if (c == ':') {
                colonFound = true;
                break;
            }
            if (c == '}' || c == ';') break;
        }
        String word = sb.reverse().toString();
        return new ProposalContext(word, colonFound, openBraceFound);
    }

    private char getChar(IDocument document, int pos) {
        char c = '\u0000';
        if (pos >= 0) {
            try {
                c = document.getChar(pos);
            }
            catch (BadLocationException badLocationException) {
                c = '\u0000';
            }
        }
        return c;
    }

    private boolean isWordChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '@';
    }

    private ICompletionProposal[] buildProposals(List<String> suggestions, String replacedWord, int offset) {
        ICompletionProposal[] proposals = new ICompletionProposal[suggestions.size()];
        int index = 0;
        Iterator<String> iterator = suggestions.iterator();
        while (iterator.hasNext()) {
            String suggestion;
            String replacementString = suggestion = iterator.next();
            int replacementOffset = offset;
            int replacementLength = replacedWord.length();
            int cursorPosition = suggestion.length();
            if (replacementString.endsWith(") ")) {
                cursorPosition -= 2;
            }
            CompletionProposal cp = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
            proposals[index++] = cp;
        }
        return proposals;
    }
}

