/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion;

import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.ProposalType;

public class ProposalContext {
    private final String word;
    private final boolean afterColon;
    private final boolean afterOpenBrace;

    public ProposalContext(String word, boolean afterColon, boolean afterOpenBrace) {
        this.word = word;
        this.afterColon = afterColon;
        this.afterOpenBrace = afterOpenBrace;
    }

    public String getWord() {
        return this.word;
    }

    public boolean isAfterColon() {
        return this.afterColon;
    }

    public boolean isAfterOpenBrace() {
        return this.afterOpenBrace;
    }

    public ProposalType getProposalType() {
        if (this.word.startsWith("@")) {
            if (this.afterColon && this.afterOpenBrace) {
                return ProposalType.ATTRIBUTE_ANNOTATION;
            }
            if (!this.afterColon && !this.afterOpenBrace) {
                return ProposalType.ENTITY_ANNOTATION;
            }
        } else if (this.afterColon && !this.afterOpenBrace) {
            return ProposalType.ATTRIBUTE_TYPE;
        }
        return ProposalType.DEFAULT;
    }

    public String toString() {
        return "ProposalContext [word='" + this.word + "', afterColon=" + this.afterColon + ", afterOpenBrace=" + this.afterOpenBrace + ", proposalType=" + (Object)((Object)this.getProposalType()) + "]";
    }
}

