/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor;

import java.util.Collections;
import java.util.List;
import org.telosys.tools.dsl.KeyWords;

public class EntityEditorUtil {
    private static final String[] TYPES;
    private static final String[] ANNOTATIONS;
    private static final String[] ANNOTATIONS_WITH_PARENTHESIS;

    static {
        List types = KeyWords.getNeutralTypes();
        TYPES = new String[types.size()];
        Collections.sort(types);
        int i = 0;
        for (String s : types) {
            EntityEditorUtil.TYPES[i++] = s;
        }
        List annotations = KeyWords.getAnnotations();
        int numberOfAnnotations = annotations.size();
        Collections.sort(annotations);
        ANNOTATIONS = new String[numberOfAnnotations];
        ANNOTATIONS_WITH_PARENTHESIS = new String[numberOfAnnotations];
        int i2 = 0;
        for (String s : annotations) {
            EntityEditorUtil.ANNOTATIONS[i2] = EntityEditorUtil.transformAnnotation(s, false);
            EntityEditorUtil.ANNOTATIONS_WITH_PARENTHESIS[i2] = EntityEditorUtil.transformAnnotation(s, true);
            ++i2;
        }
    }

    private static final String transformAnnotation(String s, boolean parenthesis) {
        String s2 = "@" + s;
        char lastChar = s.charAt(s.length() - 1);
        if (lastChar == '#' || lastChar == '%' || lastChar == '$') {
            s2 = "@" + s.substring(0, s.length() - 1);
            if (parenthesis) {
                s2 = String.valueOf(s2) + "()";
            }
        }
        return s2;
    }

    public static final String[] getEntityFieldTypes() {
        return TYPES;
    }

    public static final String[] getAnnotations() {
        return ANNOTATIONS;
    }

    public static final String[] getAnnotationsWithParenthesis() {
        return ANNOTATIONS_WITH_PARENTHESIS;
    }
}

