/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.commons;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.telosys.tools.api.GenericModelLoader;
import org.telosys.tools.api.TelosysModelException;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.dsl.DslModelManager;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.dsl.parser.model.DomainModelInfo;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.editors.dsl.commons.ModelLoadingResult;
import org.telosys.tools.generic.model.Model;

public class ModelManager {
    private ModelManager() {
    }

    public static ModelLoadingResult load(IFile eclipseModelFile) {
        File modelFile = EclipseWksUtil.toFile(eclipseModelFile);
        return ModelManager.load(modelFile);
    }

    public static ModelLoadingResult load(File modelFile) {
        ModelLoadingResult r = ModelManager.loadModel(modelFile);
        ModelManager.updateErrorMarkers(r.getEntitiesFileNames(), r.getEntitiesErrors());
        return r;
    }

    private static ModelLoadingResult loadModel(File modelFile) {
        List entitiesFileNames = DslModelUtil.getEntitiesAbsoluteFileNames((File)modelFile);
        DslModelManager modelManager = new DslModelManager();
        DomainModelInfo modelInfo = modelManager.loadModelInformation(modelFile);
        GenericModelLoader genericModelLoader = new GenericModelLoader();
        HashMap<String, List<String>> voidMap = new HashMap<String, List<String>>();
        try {
            Model model = genericModelLoader.loadModel(modelFile);
            return new ModelLoadingResult(model, modelInfo, entitiesFileNames, voidMap);
        }
        catch (TelosysModelException modelException) {
            return new ModelLoadingResult(null, modelInfo, entitiesFileNames, modelException.getParsingErrors());
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot load model !\n Unexpected exception", e);
            return new ModelLoadingResult(null, modelInfo, entitiesFileNames, voidMap);
        }
    }

    private static void updateErrorMarkers(List<String> entitiesFileNames, Map<String, List<String>> entitiesErrors) {
        for (String entityFile : entitiesFileNames) {
            String entityFileName = new File(entityFile).getName();
            String entityName = StrUtil.removeEnd((String)entityFileName, (String)".entity");
            IFile iFile = EclipseWksUtil.toIFile(entityFile);
            ModelManager.deleteErrorMarkers(iFile);
            if (entitiesErrors == null) continue;
            ModelManager.addErrorMarkers(iFile, entitiesErrors.get(entityName));
        }
    }

    private static void deleteErrorMarkers(IFile iFile) {
        try {
            iFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            MsgBox.error("Cannot delete markers", e);
        }
    }

    private static void addErrorMarkers(IFile iFile, List<String> entityErrorsList) {
        if (entityErrorsList != null) {
            for (String msg : entityErrorsList) {
                ModelManager.addErrorMarker(iFile, msg);
            }
        }
    }

    private static void addErrorMarker(IFile iFile, String message) {
        try {
            IMarker marker = iFile.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
            marker.setAttribute("lineNumber", 1);
            marker.setAttribute("message", (Object)message);
        }
        catch (CoreException e) {
            MsgBox.error("Cannot create marker", e);
        }
    }
}

