/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.telosys.tools.commons.javatypes.JavaTypes;
import org.telosys.tools.commons.javatypes.JavaTypesManager;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.editors.dbrep.TableUtil;
import org.telosys.tools.repository.model.AttributeInDbModel;

class TableViewerLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    TableViewerLabelProvider() {
    }

    private static void log(String msg) {
    }

    public String getColumnText(Object element, int columnIndex) {
        TableViewerLabelProvider.log("getColumnText(element, " + columnIndex + ")...");
        AttributeInDbModel modelColumn = this.getAttributeInDbModel("getColumnText", element);
        if (modelColumn == null) {
            return "??";
        }
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return modelColumn.getDatabaseName();
            }
            case 3: {
                return modelColumn.getDatabaseTypeNameWithSize();
            }
            case 4: {
                return modelColumn.getJdbcTypeCodeWithText();
            }
            case 5: {
                return modelColumn.getName();
            }
            case 6: {
                String sType = modelColumn.getModelFullType();
                JavaTypes types = JavaTypesManager.getJavaTypes();
                String sText = types.getTextForType(sType);
                if (sText != null) {
                    return sText;
                }
                MsgBox.error("Cannot found text for type " + sType);
                return "????";
            }
            case 7: {
                return modelColumn.getSpecialTypeInfo();
            }
        }
        return "?";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        TableViewerLabelProvider.log("getColumnImage(element, " + columnIndex + ")...");
        AttributeInDbModel column = this.getAttributeInDbModel("getColumnImage", element);
        if (column == null) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                if (column.isKeyElement()) {
                    if (column.isAutoIncremented()) {
                        return PluginImages.getImage("PRIMARYKEY_AUTOINCR");
                    }
                    if (column.isFK()) {
                        return PluginImages.getImage("PRIMARYKEY_FK");
                    }
                    return PluginImages.getImage("PRIMARYKEY");
                }
                if (!column.isFK()) break;
                return PluginImages.getImage("FOREIGNKEY");
            }
            case 3: {
                if (column.isDatabaseNotNull()) {
                    return PluginImages.getImage("NOTNULL_ON");
                }
                return PluginImages.getImage("NOTNULL_OFF");
            }
            case 6: {
                return null;
            }
            case 7: {
                return TableUtil.getJavaNotNullImage(column);
            }
        }
        return null;
    }

    private AttributeInDbModel getAttributeInDbModel(String methodName, Object element) {
        if (!(element instanceof AttributeInDbModel)) {
            MsgBox.error("Class " + ((Object)((Object)this)).getClass().getSimpleName(), "Method '" + methodName + "' : element is not an instance of AttributeInDbModel !");
            return null;
        }
        return (AttributeInDbModel)element;
    }
}

