/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;
import org.telosys.tools.commons.JavaTypeUtil;
import org.telosys.tools.commons.javatypes.JavaTypes;
import org.telosys.tools.commons.javatypes.JavaTypesManager;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dbrep.RepositoryEditor;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValue;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValueForBoolean;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValueForDate;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValueForNumber;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValueForString;
import org.telosys.tools.eclipse.plugin.editors.dbrep.TableUtil;
import org.telosys.tools.generic.model.DateType;
import org.telosys.tools.repository.model.AttributeInDbModel;

class TableViewerCellModifier
implements ICellModifier {
    RepositoryEditor _editor = null;

    private static void log(String msg) {
    }

    public TableViewerCellModifier(RepositoryEditor editor) {
        this._editor = editor;
    }

    private void setDirty() {
        this._editor.setDirty();
    }

    private AttributeInDbModel getTableRow(Object element) {
        if (element instanceof AttributeInDbModel) {
            return (AttributeInDbModel)element;
        }
        MsgBox.error("TableViewerCellModifier.getTableRow(element) : the element is not an instance of AttributeInDbModel !");
        return null;
    }

    public boolean canModify(Object element, String property) {
        AttributeInDbModel row;
        TableViewerCellModifier.log("canModify(..," + property + ")...");
        if ("javaName".equals(property)) {
            return true;
        }
        if ("javaType".equals(property)) {
            return true;
        }
        return "special".equals(property) && (row = this.getTableRow(element)) != null;
    }

    public Object getValue(Object element, String property) {
        TableViewerCellModifier.log("getValue(element,'" + property + "')...");
        AttributeInDbModel column = this.getTableRow(element);
        if (column != null) {
            if ("javaName".equals(property)) {
                return column.getName();
            }
            if ("javaType".equals(property)) {
                String sJavaType = column.getModelFullType();
                if (sJavaType != null) {
                    JavaTypes types = JavaTypesManager.getJavaTypes();
                    int index = types.getTypeIndex(sJavaType);
                    if (index < 0) {
                        MsgBox.error("getValue(element, '" + property + "') : " + "\n Cannot found index for type '" + sJavaType + "' !");
                        return new Integer(0);
                    }
                    return new Integer(index);
                }
                MsgBox.error("getValue(element, '" + property + "') : " + "\n 'Java Type' value is null !");
                return new Integer(0);
            }
            if ("special".equals(property)) {
                if (column.isJavaTypeString()) {
                    TableViewerCellModifier.log("getValue(..," + property + ") : return SpecialValueForString");
                    return new SpecialValueForString(column);
                }
                if (column.isJavaTypeDateOrTime()) {
                    TableViewerCellModifier.log("getValue(..," + property + ") : return SpecialValueForDate");
                    return new SpecialValueForDate(column);
                }
                if (column.isJavaTypeBoolean()) {
                    TableViewerCellModifier.log("getValue(..," + property + ") : return SpecialValueForBoolean");
                    return new SpecialValueForBoolean(column);
                }
                if (column.isJavaTypeNumber()) {
                    TableViewerCellModifier.log("getValue(..," + property + ") : return SpecialValueForNumber");
                    return new SpecialValueForNumber(column);
                }
                PluginLogger.log(this, "getValue(..," + property + ") : return 'NULL'");
                return null;
            }
        }
        return "?";
    }

    public void modify(Object element, String property, Object value) {
        TableViewerCellModifier.log("modify(element, '" + property + "', value)...");
        if (!(element instanceof TableItem)) {
            MsgBox.error("modify(element, property, val) : the element is not an instance of TableItem !");
            return;
        }
        TableItem tableItem = (TableItem)element;
        AttributeInDbModel modelColumn = TableUtil.getTableColumn(tableItem);
        if ("javaName".equals(property)) {
            TableViewerCellModifier.log("modify(..," + property + ", " + value + ") : 'Java Name' column ");
            String sNewValue = this.getString(value);
            String sOldValue = modelColumn.getName();
            if (!sNewValue.equals(sOldValue)) {
                modelColumn.setName(sNewValue);
                tableItem.setText(5, sNewValue);
                this.setDirty();
            }
        }
        if ("javaType".equals(property)) {
            TableViewerCellModifier.log("modify(..," + property + ", " + value + ") : 'Java Type' column ( original value = '" + modelColumn.getModelFullType() + "' )");
            String sNewInput = "???";
            int iChoice = this.getInt(value);
            JavaTypes types = JavaTypesManager.getJavaTypes();
            sNewInput = types.getText(iChoice);
            String sNewFullType = types.getType(iChoice);
            TableViewerCellModifier.log("modify(..," + property + ", " + value + ") : Full type = " + sNewFullType);
            String sOldFullType = modelColumn.getModelFullType();
            if (sNewFullType.equals(sOldFullType)) {
                TableViewerCellModifier.log("modify(..," + property + ", " + value + ") : New value = Original value (no change) ");
                return;
            }
            TableViewerCellModifier.log("modify(..," + property + ", " + value + ") : has changed '" + sOldFullType + "' -> '" + sNewFullType + "' ");
            this.updateJavaTypeInModel(modelColumn, sNewFullType);
            tableItem.setText(6, sNewInput);
            this.refreshSpecialColumn(tableItem);
            this.setDirty();
        }
        if ("special".equals(property)) {
            TableViewerCellModifier.log("modify(..," + property + ", " + value + ") : 'Special' column ");
            if (value != null) {
                SpecialValue specialValue;
                if (value instanceof SpecialValue && (specialValue = (SpecialValue)value).hasChanged()) {
                    this.refreshSpecialColumn(tableItem);
                    this.setDirty();
                }
            } else {
                TableViewerCellModifier.log("modify(..," + property + ", " + value + ") : 'Special' column : value is NULL => no change");
                String s = tableItem.getText(7);
                tableItem.setText(7, s);
            }
        }
    }

    private void refreshSpecialColumn(TableItem tableItem) {
        AttributeInDbModel modelColumn = TableUtil.getTableColumn(tableItem);
        if (modelColumn != null) {
            tableItem.setText(7, modelColumn.getSpecialTypeInfo());
            Image image = TableUtil.getJavaNotNullImage(modelColumn);
            tableItem.setImage(7, image);
        }
    }

    private String getString(Object oValue) {
        if (oValue instanceof String) {
            return (String)oValue;
        }
        MsgBox.error("ERROR in modify(element, property, value) : \n The value is not an instance of String !\n Class is " + oValue.getClass().getName());
        return "?";
    }

    private int getInt(Object oValue) {
        TableViewerCellModifier.log("getInt(" + oValue + ")");
        if (oValue instanceof Integer) {
            Integer integer = (Integer)oValue;
            int v = integer;
            TableViewerCellModifier.log("getInt(" + oValue + ") : " + v);
            return v;
        }
        MsgBox.error("ERROR in modify(element, property, value) : \n The value is not an instance of Integer !\n Class is " + oValue.getClass().getName());
        return 0;
    }

    private void updateJavaTypeInModel(AttributeInDbModel modelColumn, String sNewFullType) {
        String sOldFullType = modelColumn.getModelFullType();
        modelColumn.setModelFullType(sNewFullType);
        if (JavaTypeUtil.getCategory((String)sOldFullType) != JavaTypeUtil.getCategory((String)sNewFullType)) {
            this.resetFurtherInfo(modelColumn);
        } else if (JavaTypeUtil.isCategoryDateOrTime((String)sNewFullType)) {
            this.resetFurtherInfo(modelColumn);
        }
    }

    private void resetFurtherInfo(AttributeInDbModel modelColumn) {
        modelColumn.clearSpecialTypeInfo();
        String sFullJavaType = modelColumn.getModelFullType();
        int jdbcCode = modelColumn.getJdbcTypeCode();
        if ("java.util.Date".equals(sFullJavaType)) {
            switch (jdbcCode) {
                case 91: {
                    modelColumn.setDateType(DateType.DATE_ONLY);
                    break;
                }
                case 92: {
                    modelColumn.setDateType(DateType.TIME_ONLY);
                    break;
                }
                case 93: {
                    modelColumn.setDateType(DateType.DATE_AND_TIME);
                    break;
                }
                default: {
                    modelColumn.setDateType(DateType.DATE_ONLY);
                    break;
                }
            }
        } else if (modelColumn.isJavaTypeString()) {
            if (jdbcCode == -1 || jdbcCode == 2005) {
                modelColumn.setLongText(true);
            }
        } else if (modelColumn.isJavaTypeBoolean() && jdbcCode != 16) {
            modelColumn.setBooleanTrueValue("1");
            modelColumn.setBooleanFalseValue("0");
        }
    }
}

