/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.math.BigDecimal;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValue;
import org.telosys.tools.repository.model.AttributeInDbModel;

public class SpecialValueForNumber
extends SpecialValue {
    private BigDecimal _initialMinValue;
    private BigDecimal _initialMaxValue;
    private String _initialFormat;

    public SpecialValueForNumber(AttributeInDbModel modelColumn) {
        super(modelColumn);
        this._initialMinValue = this._modelColumn.getMinValue();
        this._initialMaxValue = this._modelColumn.getMaxValue();
        this._initialFormat = this._modelColumn.getFormat();
    }

    public String getMinValue() {
        return this.emptyIfNull(this._modelColumn.getMinValue());
    }

    public void setMinValue(String s) {
        this.log("setMin(" + s + ")");
        this._modelColumn.setMinValue(StrUtil.getBigDecimalObject((String)s));
    }

    public String getMaxValue() {
        return this.emptyIfNull(this._modelColumn.getMaxValue());
    }

    public void setMaxValue(String s) {
        this.log("setMax(" + s + ")");
        this._modelColumn.setMaxValue(StrUtil.getBigDecimalObject((String)s));
    }

    public String getFormat() {
        return this.emptyIfNull(this._modelColumn.getFormat());
    }

    public void setFormat(String s) {
        this.log("setFormat(" + s + ")");
        this._modelColumn.setFormat(s);
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this._initialMinValue != this._modelColumn.getMinValue()) {
            return true;
        }
        if (this._initialMaxValue != this._modelColumn.getMaxValue()) {
            return true;
        }
        return !this.sameValue(this._initialFormat, this._modelColumn.getFormat());
    }

    @Override
    public void cancelChanges() {
        super.cancelChanges();
        this._modelColumn.setMinValue(this._initialMinValue);
        this._modelColumn.setMaxValue(this._initialMaxValue);
        this._modelColumn.setFormat(this._initialFormat);
    }
}

