/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.io.File;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.telosys.tools.api.GenericModelLoader;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.TelosysToolsLogger;
import org.telosys.tools.eclipse.plugin.commons.ModelUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditor;
import org.telosys.tools.eclipse.plugin.editors.dbrep.RepositoryEditorPageCodeGeneration;
import org.telosys.tools.eclipse.plugin.editors.dbrep.RepositoryEditorPageModelEntities;
import org.telosys.tools.eclipse.plugin.editors.dbrep.RepositoryEditorPageModelInfo;
import org.telosys.tools.eclipse.plugin.editors.dbrep.RepositoryEditorPageModelLinks;
import org.telosys.tools.generic.model.Model;
import org.telosys.tools.repository.model.RepositoryModel;
import org.telosys.tools.repository.persistence.PersistenceManager;
import org.telosys.tools.repository.persistence.PersistenceManagerFactory;

public class RepositoryEditor
extends AbstractModelEditor {
    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.log((Object)this, "init()...");
        this.loadModel();
    }

    protected void addPages() {
        this.log((Object)this, "addPages()...");
        RepositoryEditorPageModelEntities page1 = new RepositoryEditorPageModelEntities(this, "RepositoryEditorPageId1", " Model : Entities attributes and mapping ");
        RepositoryEditorPageModelLinks page2 = new RepositoryEditorPageModelLinks(this, "RepositoryEditorPageId2", " Model : Links between entities ");
        RepositoryEditorPageModelInfo page3 = new RepositoryEditorPageModelInfo(this, "RepositoryEditorPageId3", " Model : Information ");
        RepositoryEditorPageCodeGeneration page4 = new RepositoryEditorPageCodeGeneration(this, "RepositoryEditorPageId4", " Code generation ");
        try {
            this.addPage((IFormPage)page1);
            this.addPage((IFormPage)page2);
            this.addPage((IFormPage)page3);
            this.addPage((IFormPage)page4);
            this.log((Object)this, "addPages() : all pages added");
        }
        catch (PartInitException e) {
            MsgBox.error("RepositoryEditor : addPage(page) throws PartInitException ", e);
        }
    }

    @Override
    protected Model loadModel(File modelFile) {
        this.log((Object)this, "loadModel(" + modelFile + ")");
        GenericModelLoader genericModelLoader = new GenericModelLoader();
        try {
            Model model = genericModelLoader.loadModel(modelFile);
            return model;
        }
        catch (Exception ex) {
            MsgBox.error("Cannot load model ", ex);
            return null;
        }
    }

    @Override
    public void saveModel(Model model, File modelFile) {
        RepositoryModel repositoryModel;
        this.log((Object)this, "saveModel(" + modelFile + ")");
        try {
            repositoryModel = ModelUtil.toRepositoryModel(model);
        }
        catch (Exception exception) {
            MsgBox.error("Cannot save model.\n Cannot convert the given model to RepositoryModel");
            return;
        }
        PersistenceManager persistenceManager = PersistenceManagerFactory.createPersistenceManager((File)modelFile, (TelosysToolsLogger)this.getLogger());
        try {
            persistenceManager.save(repositoryModel);
            this.log((Object)this, "Repository saved.");
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot save repository", e);
        }
    }
}

