/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.eclipse.plugin.editors.dbrep.DialogBox;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValueForString;

public class DialogBoxForString
extends DialogBox {
    private Button _cbLongText = null;
    private Button _cbNotNull = null;
    private Button _cbNotBlank = null;
    private Button _cbNotEmpty = null;
    private Text _textMinLength = null;
    private Text _textMaxLength = null;
    private Text _textPattern = null;
    private SpecialValueForString _value = null;

    public DialogBoxForString(Shell parentShell, SpecialValueForString value) {
        super(parentShell, value);
        this.log("DialogBoxForString(Shell parentShell, SpecialValueForString value) CONSTRUCTOR");
        this._value = value;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.log("createContents(Composite parent) ...");
        Control result = super.createContents(parent);
        this.setMessage("String type and validation rules", 1);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.log("createDialogArea(Composite parent) ...");
        Composite content = this.createDialogAreaContainer(parent);
        this.createStringTypeGroup(content);
        this.createValidationGroup(content);
        this.dataToView();
        return content;
    }

    private Group createStringTypeGroup(Composite container) {
        this.log("createStringTypeGroup() ...");
        Group group = this.createDialogAreaGroup(container, " String type ");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = 100;
        this._cbLongText = new Button((Composite)group, 32);
        this._cbLongText.setText("Long text (e.g. text requiring a textarea)");
        return group;
    }

    private Group createValidationGroup(Composite container) {
        this.log("createValidationGroup() ...");
        Group group = this.createDialogAreaGroup(container, " Validation rules ");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        GridData gdSpan = new GridData();
        gdSpan.verticalAlignment = 4;
        gdSpan.grabExcessVerticalSpace = true;
        gdSpan.horizontalSpan = 2;
        gdSpan.widthHint = 300;
        gdSpan.minimumWidth = 300;
        GridData gdLabel = new GridData();
        gdLabel.widthHint = 120;
        gdLabel.minimumWidth = 120;
        GridData gdTextLength = new GridData();
        gdTextLength.widthHint = 80;
        gdTextLength.minimumWidth = 80;
        GridData gdTextPattern = new GridData();
        gdTextPattern.widthHint = 300;
        gdTextPattern.minimumWidth = 300;
        this._cbNotNull = new Button((Composite)group, 32);
        this._cbNotNull.setText("Not null ");
        this._cbNotNull.setSelection(false);
        this._cbNotNull.setLayoutData((Object)gdSpan);
        this._cbNotEmpty = new Button((Composite)group, 32);
        this._cbNotEmpty.setText("Not empty ");
        this._cbNotEmpty.setSelection(false);
        this._cbNotEmpty.setLayoutData((Object)gdSpan);
        this._cbNotBlank = new Button((Composite)group, 32);
        this._cbNotBlank.setText("Not blank ");
        this._cbNotBlank.setSelection(false);
        this._cbNotBlank.setLayoutData((Object)gdSpan);
        Label label = new Label((Composite)group, 0);
        label.setText("Minimum length : ");
        label.setLayoutData((Object)gdLabel);
        this._textMinLength = new Text((Composite)group, 2048);
        this._textMinLength.setText("");
        this._textMinLength.setLayoutData((Object)gdTextLength);
        label = new Label((Composite)group, 0);
        label.setText("Maximum length : ");
        label.setLayoutData((Object)gdLabel);
        this._textMaxLength = new Text((Composite)group, 2048);
        this._textMaxLength.setText("");
        this._textMaxLength.setLayoutData((Object)gdTextLength);
        label = new Label((Composite)group, 0);
        label.setText("Pattern (RegExp) : ");
        label.setLayoutData((Object)gdLabel);
        this._textPattern = new Text((Composite)group, 2048);
        this._textPattern.setText("");
        this._textPattern.setLayoutData((Object)gdTextPattern);
        return group;
    }

    @Override
    public boolean onOK() {
        this.log("onOK");
        if (this.checkViewValues()) {
            this.viewToData();
            return true;
        }
        return false;
    }

    private boolean checkViewValues() {
        if (!this.checkNumericValue(this._textMinLength.getText(), "Invalid minimum length")) {
            return false;
        }
        if (!this.checkNumericValue(this._textMaxLength.getText(), "Invalid maximum length")) {
            return false;
        }
        return this.isLowerThan(this._textMinLength.getText(), this._textMaxLength.getText(), "Min length / Max length inverted");
    }

    private void dataToView() {
        this.log("dataToView() ...");
        this._cbLongText.setSelection(this._value.isLongText());
        this._cbNotNull.setSelection(this._value.isNotNull());
        this._cbNotEmpty.setSelection(this._value.isNotEmpty());
        this._cbNotBlank.setSelection(this._value.isNotBlank());
        this._textMinLength.setText(this._value.getMinLength());
        this._textMaxLength.setText(this._value.getMaxLength());
        this._textPattern.setText(this._value.getPattern());
        this.log("dataToView() : END");
    }

    private void viewToData() {
        this.log("viewToData() ...");
        this._value.setLongText(this._cbLongText.getSelection());
        this._value.setNotNull(this._cbNotNull.getSelection());
        this._value.setNotEmpty(this._cbNotEmpty.getSelection());
        this._value.setNotBlank(this._cbNotBlank.getSelection());
        this._value.setMinLength(this.trim(this._textMinLength.getText()));
        this._value.setMaxLength(this.trim(this._textMaxLength.getText()));
        this._value.setPattern(this._textPattern.getText());
    }
}

