/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.generic.model.Cardinality;
import org.telosys.tools.generic.model.CascadeOption;
import org.telosys.tools.generic.model.CascadeOptions;
import org.telosys.tools.generic.model.FetchType;
import org.telosys.tools.generic.model.Optional;
import org.telosys.tools.repository.model.LinkInDbModel;

public class DialogBoxForLink
extends TitleAreaDialog {
    private static final String[] cardinalityAll = new String[]{"One To One", "Many To One", "One To Many", "Many To Many"};
    private static final String[] cardinalityToOne = new String[]{"One To One", "Many To One"};
    private static final int ONE_TO_ONE = 0;
    private static final int MANY_TO_ONE = 1;
    private static final int ONE_TO_MANY = 2;
    private static final int MANY_TO_MANY = 3;
    private static final int OPTIONAL_UNDEFINED = 0;
    private static final int OPTIONAL_TRUE = 1;
    private static final int OPTIONAL_FALSE = 2;
    private static final int FETCH_DEFAULT = 0;
    private static final int FETCH_LAZY = 1;
    private static final int FETCH_EAGER = 2;
    Combo _comboCardinality = null;
    Combo _comboFecthType = null;
    Text _textJavaFieldName = null;
    Combo _comboJavaFieldType = null;
    Combo _comboOptional = null;
    Button _checkBoxCascadeAll = null;
    Button _checkBoxCascadeMerge = null;
    Button _checkBoxCascadePersist = null;
    Button _checkBoxCascadeRefresh = null;
    Button _checkBoxCascadeRemove = null;
    LinkInDbModel _link = null;
    private static final String[] collectionItems = new String[]{"java.util.List", "java.util.Set", "java.util.Collection", "java.util.Map"};

    public DialogBoxForLink(Shell parentShell, LinkInDbModel link) {
        super(parentShell);
        PluginLogger.log((Object)this, "DialogBox CONSTRUCTOR ...");
        this.setHelpAvailable(false);
        this._link = link;
    }

    protected void log(String s) {
        PluginLogger.log((Object)this, s);
    }

    protected Control createContents(Composite parent) {
        this.log("createContents() ...");
        Control result = super.createContents(parent);
        this.setTitle("Link from " + this._link.getSourceTableName() + " to " + this._link.getTargetTableName());
        String message = this._link.isBasedOnForeignKey() ? "Based on Foreign Key \"" + this._link.getForeignKeyName() + "\"" : (this._link.isBasedOnJoinTable() ? "Based on Join Table \"" + this._link.getJoinTableName() + "\"" : "");
        this.setMessage(message, 1);
        return result;
    }

    protected Composite createDialogAreaContainer(Composite parent) {
        this.log("createDialogAreaContainer() ...");
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        content.setLayout((Layout)gridLayout);
        return content;
    }

    protected Composite createCascadeOptions(Composite parent) {
        this.log("createCascadeOptions() ...");
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        content.setLayout((Layout)gridLayout);
        this._checkBoxCascadeAll = new Button(content, 32);
        this._checkBoxCascadeAll.setText("All");
        this._checkBoxCascadeMerge = new Button(content, 32);
        this._checkBoxCascadeMerge.setText("Merge");
        this._checkBoxCascadePersist = new Button(content, 32);
        this._checkBoxCascadePersist.setText("Persist");
        new Label(content, 0).setText("");
        this._checkBoxCascadeRefresh = new Button(content, 32);
        this._checkBoxCascadeRefresh.setText("Refresh");
        this._checkBoxCascadeRemove = new Button(content, 32);
        this._checkBoxCascadeRemove.setText("Remove");
        return content;
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        PluginLogger.log((Object)this, "createDialogArea() ...");
        Composite content = this.createDialogAreaContainer(parent);
        GridData gd1 = new GridData();
        gd1.grabExcessHorizontalSpace = true;
        gd1.minimumWidth = 100;
        gd1.verticalAlignment = 128;
        gd1.minimumHeight = 24;
        gd1.grabExcessVerticalSpace = true;
        GridData gd2 = new GridData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.minimumWidth = 100;
        gd2.verticalAlignment = 128;
        GridData gd2_long = new GridData();
        gd2_long.grabExcessHorizontalSpace = true;
        gd2_long.minimumWidth = 240;
        gd2_long.verticalAlignment = 128;
        if (this._link.isOwningSide()) {
            label = new Label(content, 0);
            label.setText("Owning side");
            label.setLayoutData((Object)gd1);
            label = new Label(content, 0);
            label.setText("");
            label.setLayoutData((Object)gd2_long);
        } else {
            label = new Label(content, 0);
            label.setText("Inverse side");
            label.setLayoutData((Object)gd1);
            label = new Label(content, 0);
            label.setText("mapped by \"" + this._link.getMappedBy() + "\"");
            label.setLayoutData((Object)gd2_long);
        }
        label = new Label(content, 0);
        label.setText("Cardinality : ");
        label.setLayoutData((Object)gd1);
        this._comboCardinality = new Combo(content, 8);
        this._comboCardinality.setItems(cardinalityAll);
        this._comboCardinality.setLayoutData((Object)gd2);
        label = new Label(content, 0);
        label.setText("Target entity : ");
        label.setLayoutData((Object)gd1);
        Text text = new Text(content, 2056);
        text.setText(this._link.getTargetEntityClassName());
        text.setLayoutData((Object)gd2_long);
        label = new Label(content, 0);
        label.setText("Java field type : ");
        label.setLayoutData((Object)gd1);
        this._comboJavaFieldType = new Combo(content, 4);
        this._comboJavaFieldType.setLayoutData((Object)gd2_long);
        label = new Label(content, 0);
        label.setText("Java field name : ");
        label.setLayoutData((Object)gd1);
        this._textJavaFieldName = new Text(content, 2048);
        this._textJavaFieldName.setLayoutData((Object)gd2_long);
        label = new Label(content, 0);
        label.setText("Optional : ");
        label.setLayoutData((Object)gd1);
        this._comboOptional = new Combo(content, 8);
        this._comboOptional.add("Undefined");
        this._comboOptional.add("True");
        this._comboOptional.add("False");
        this._comboOptional.setLayoutData((Object)gd2);
        label = new Label(content, 0);
        label.setText("Fetch type : ");
        label.setLayoutData((Object)gd1);
        this._comboFecthType = new Combo(content, 8);
        this._comboFecthType.add("Default");
        this._comboFecthType.add("Lazy");
        this._comboFecthType.add("Eager");
        this._comboFecthType.setLayoutData((Object)gd2);
        label = new Label(content, 0);
        label.setText("Cascade : ");
        label.setLayoutData((Object)gd1);
        this.createCascadeOptions(content);
        this.dataToView(this._link);
        return content;
    }

    protected Group createDialogAreaGroup(Composite container, String text) {
        Group group = new Group(container, 0);
        if (text != null) {
            group.setText(text);
        }
        return group;
    }

    protected void okPressed() {
        PluginLogger.log((Object)this, " ==== OK Pressed ");
        if (this.checkViewValues()) {
            this.viewToData(this._link);
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        PluginLogger.log((Object)this, " ==== CANCEL Pressed ");
        super.cancelPressed();
    }

    private boolean checkViewValues() {
        return true;
    }

    private void viewToData(LinkInDbModel link) {
        this.log("viewToData() ...");
        switch (this._comboCardinality.getSelectionIndex()) {
            case 0: {
                link.setCardinality(Cardinality.ONE_TO_ONE);
                break;
            }
            case 1: {
                link.setCardinality(Cardinality.MANY_TO_ONE);
                break;
            }
            case 2: {
                link.setCardinality(Cardinality.ONE_TO_MANY);
                break;
            }
            case 3: {
                link.setCardinality(Cardinality.MANY_TO_MANY);
            }
        }
        link.setFieldName(this._textJavaFieldName.getText());
        link.setFieldType(this._comboJavaFieldType.getText());
        switch (this._comboOptional.getSelectionIndex()) {
            case 0: {
                link.setOptional(Optional.UNDEFINED);
                break;
            }
            case 1: {
                link.setOptional(Optional.TRUE);
                break;
            }
            case 2: {
                link.setOptional(Optional.FALSE);
            }
        }
        switch (this._comboFecthType.getSelectionIndex()) {
            case 0: {
                link.setFetchType(FetchType.DEFAULT);
                break;
            }
            case 1: {
                link.setFetchType(FetchType.LAZY);
                break;
            }
            case 2: {
                link.setFetchType(FetchType.EAGER);
            }
        }
        if (this._checkBoxCascadeAll.getSelection()) {
            CascadeOptions cascadeOptions = new CascadeOptions();
            cascadeOptions.add(CascadeOption.ALL);
            link.setCascadeOptions(cascadeOptions);
        } else {
            CascadeOptions cascadeOptions = new CascadeOptions();
            if (this._checkBoxCascadeMerge.getSelection()) {
                cascadeOptions.add(CascadeOption.MERGE);
            }
            if (this._checkBoxCascadePersist.getSelection()) {
                cascadeOptions.add(CascadeOption.PERSIST);
            }
            if (this._checkBoxCascadeRefresh.getSelection()) {
                cascadeOptions.add(CascadeOption.REFRESH);
            }
            if (this._checkBoxCascadeRemove.getSelection()) {
                cascadeOptions.add(CascadeOption.REMOVE);
            }
            link.setCascadeOptions(cascadeOptions);
        }
        this.log("viewToData() : END ");
    }

    private void dataToView(LinkInDbModel link) {
        this.log("dataToView() ...");
        if (link.getCardinality() == Cardinality.ONE_TO_ONE) {
            this._comboCardinality.setItems(cardinalityToOne);
            this._comboCardinality.select(0);
            this._comboCardinality.setEnabled(true);
        } else if (link.getCardinality() == Cardinality.MANY_TO_ONE) {
            this._comboCardinality.setItems(cardinalityToOne);
            this._comboCardinality.select(1);
            this._comboCardinality.setEnabled(true);
        } else if (link.getCardinality() == Cardinality.ONE_TO_MANY) {
            this._comboCardinality.setItems(cardinalityAll);
            this._comboCardinality.select(2);
            this._comboCardinality.setEnabled(false);
        } else if (link.getCardinality() == Cardinality.MANY_TO_MANY) {
            this._comboCardinality.setItems(cardinalityAll);
            this._comboCardinality.select(3);
            this._comboCardinality.setEnabled(false);
        }
        if (link.isInverseSide()) {
            this._comboCardinality.setEnabled(false);
        }
        this._textJavaFieldName.setText(link.getFieldName());
        this.populateComboJavaFieldType(link);
        if (link.isCardinalityOneToOne() || link.isCardinalityManyToOne()) {
            if (link.getOptional() == Optional.UNDEFINED) {
                this._comboOptional.select(0);
            }
            if (link.getOptional() == Optional.TRUE) {
                this._comboOptional.select(1);
            }
            if (link.getOptional() == Optional.FALSE) {
                this._comboOptional.select(2);
            }
            this._comboOptional.setEnabled(true);
        } else {
            this._comboOptional.select(0);
            this._comboOptional.setEnabled(false);
        }
        if (link.getFetchType() == FetchType.DEFAULT) {
            this._comboFecthType.select(0);
        }
        if (link.getFetchType() == FetchType.LAZY) {
            this._comboFecthType.select(1);
        }
        if (link.getFetchType() == FetchType.EAGER) {
            this._comboFecthType.select(2);
        }
        CascadeOptions cascadeOptions = link.getCascadeOptions();
        this._checkBoxCascadeAll.setSelection(cascadeOptions.isCascadeAll());
        this._checkBoxCascadeMerge.setSelection(cascadeOptions.isCascadeMerge());
        this._checkBoxCascadePersist.setSelection(cascadeOptions.isCascadePersist());
        this._checkBoxCascadeRefresh.setSelection(cascadeOptions.isCascadeRefresh());
        this._checkBoxCascadeRemove.setSelection(cascadeOptions.isCascadeRemove());
        this.log("dataToView() : END");
    }

    private void populateComboJavaFieldType(LinkInDbModel link) {
        Cardinality cardinality = link.getCardinality();
        if (cardinality != null) {
            if (cardinality == Cardinality.MANY_TO_ONE || cardinality == Cardinality.ONE_TO_ONE) {
                String[] entityItems = new String[]{link.getTargetEntityClassName()};
                this._comboJavaFieldType.setItems(entityItems);
                this.selectComboJavaFieldType(link.getFieldType());
            } else if (cardinality == Cardinality.ONE_TO_MANY || cardinality == Cardinality.MANY_TO_MANY) {
                this._comboJavaFieldType.setItems(collectionItems);
                this.selectComboJavaFieldType(link.getFieldType());
            }
        } else {
            String[] nothing = new String[]{""};
            this._comboJavaFieldType.setItems(nothing);
            this._comboJavaFieldType.select(0);
        }
    }

    private void selectComboJavaFieldType(String type) {
        if (type == null) {
            this._comboJavaFieldType.setText("");
            return;
        }
        String[] items = this._comboJavaFieldType.getItems();
        int i = 0;
        while (i < items.length) {
            if (type.equals(items[i])) {
                this._comboJavaFieldType.select(i);
                return;
            }
            ++i;
        }
        this._comboJavaFieldType.setText(type);
    }
}

