/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.math.BigDecimal;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValue;

public abstract class DialogBox
extends TitleAreaDialog {
    private static final int ROW_WIDTH = 500;
    private RowData _rowData = new RowData(500, -1);
    private SpecialValue _value = null;
    private Text _textFieldLabel = null;
    private Text _textFieldInputType = null;

    public abstract boolean onOK();

    public DialogBox(Shell parentShell, SpecialValue value) {
        super(parentShell);
        PluginLogger.log((Object)this, "DialogBox CONSTRUCTOR ...");
        this.setHelpAvailable(false);
        this._value = value;
    }

    protected void log(String s) {
        PluginLogger.log((Object)this, s);
    }

    public Object getValue() {
        return this._value;
    }

    protected Control createContents(Composite parent) {
        this.log("createContents() ...");
        Control result = super.createContents(parent);
        this.setTitle("Further information for '" + this._value.getJavaType() + "' type");
        return result;
    }

    protected Composite createDialogAreaContainer(Composite parent) {
        this.log("createDialogAreaContainer() ...");
        Composite content = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.justify = true;
        rowLayout.marginLeft = 10;
        rowLayout.marginRight = 10;
        rowLayout.spacing = 10;
        content.setLayout((Layout)rowLayout);
        this.createStandardGroup(content);
        this._textFieldLabel.setText(this._value.getLabel());
        this._textFieldInputType.setText(this._value.getInputType());
        return content;
    }

    private Group createStandardGroup(Composite container) {
        this.log("createFirstGroup() ...");
        Group group = this.createDialogAreaGroup(container, null);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        GridData gdSpan = new GridData();
        gdSpan.verticalAlignment = 4;
        gdSpan.grabExcessVerticalSpace = true;
        gdSpan.horizontalSpan = 2;
        GridData gdLabel = new GridData();
        GridData gdText = new GridData();
        gdText.widthHint = 200;
        gdText.minimumWidth = 200;
        Label label = new Label((Composite)group, 0);
        label.setText("Label : ");
        label.setLayoutData((Object)gdLabel);
        this._textFieldLabel = new Text((Composite)group, 2048);
        this._textFieldLabel.setText("");
        this._textFieldLabel.setLayoutData((Object)gdText);
        label = new Label((Composite)group, 0);
        label.setText("Input type : ");
        label.setLayoutData((Object)gdLabel);
        this._textFieldInputType = new Text((Composite)group, 2048);
        this._textFieldInputType.setText("");
        this._textFieldInputType.setLayoutData((Object)gdText);
        return group;
    }

    protected Group createDialogAreaGroup(Composite container, String text) {
        Group group = new Group(container, 0);
        if (text != null) {
            group.setText(text);
        }
        group.setLayoutData((Object)this._rowData);
        return group;
    }

    protected void dataToNotNullCheckBox(Button cbNotNull) {
        if (this._value.isPrimitiveType()) {
            cbNotNull.setSelection(false);
            cbNotNull.setEnabled(false);
        } else {
            cbNotNull.setSelection(this._value.isNotNull());
            cbNotNull.setEnabled(true);
        }
    }

    protected void okPressed() {
        PluginLogger.log((Object)this, " ==== OK Pressed ");
        if (this.onOK()) {
            this._value.setLabel(this._textFieldLabel.getText());
            this._value.setInputType(this._textFieldInputType.getText());
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        PluginLogger.log((Object)this, " ==== CANCEL Pressed ");
        super.cancelPressed();
    }

    protected boolean checkNumericValue(String s, String msg) {
        if (StrUtil.nullOrVoid((String)s)) {
            return true;
        }
        try {
            new BigDecimal(s.trim());
            return true;
        }
        catch (Throwable throwable) {
            MsgBox.error(msg);
            return false;
        }
    }

    protected boolean isLowerThan(String s1, String s2, String msg) {
        if (StrUtil.nullOrVoid((String)s1)) {
            return true;
        }
        if (StrUtil.nullOrVoid((String)s2)) {
            return true;
        }
        try {
            BigDecimal d1 = new BigDecimal(s1.trim());
            BigDecimal d2 = new BigDecimal(s2.trim());
            if (d1.compareTo(d2) > 0) {
                MsgBox.error(msg);
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            MsgBox.error("Invalid numeric value");
            return false;
        }
    }

    protected String trim(String s) {
        if (s != null) {
            return s.trim();
        }
        return s;
    }
}

