/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbconfig;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.telosys.tools.commons.dbcfg.DatabaseType;
import org.telosys.tools.commons.dbcfg.DatabaseTypeProvider;
import org.telosys.tools.commons.dbcfg.DatabasesConfigurations;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public class DialogBoxNewDatabase
extends TitleAreaDialog {
    private static final int ROW_WIDTH = 500;
    private final DatabasesConfigurations databasesConfigurations;
    private Combo comboDatabaseId = null;
    private Combo comboDatabaseType = null;
    private int selectedDatabaseId = -1;
    private DatabaseType selectedDatabaseType = null;

    public DialogBoxNewDatabase(Shell parentShell, DatabasesConfigurations databasesConfigurations) {
        super(parentShell);
        PluginLogger.log((Object)this, "DialogBox CONSTRUCTOR ...");
        this.setHelpAvailable(false);
        this.databasesConfigurations = databasesConfigurations;
    }

    private void log(String s) {
        PluginLogger.log((Object)this, s);
    }

    protected Control createContents(Composite parent) {
        this.log("createContents() ...");
        Control result = super.createContents(parent);
        this.setTitle("New database configuration");
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.log("createDialogArea() ...");
        Composite content = this.createDialogAreaContainer(parent);
        this.populateDatabaseIdCombo();
        this.populateDatabaseTypeCombo();
        return content;
    }

    private Composite createDialogAreaContainer(Composite parent) {
        this.log("createDialogAreaContainer() ...");
        Composite content = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.justify = true;
        rowLayout.marginLeft = 10;
        rowLayout.marginRight = 10;
        rowLayout.spacing = 10;
        content.setLayout((Layout)rowLayout);
        this.createDialogAreaGroup(content);
        return content;
    }

    private Group createDialogAreaGroup(Composite container) {
        this.log("createDialogAreaGroup() ...");
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new RowData(500, -1));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginTop = 6;
        gridLayout.marginBottom = 12;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        GridData gdLabel = new GridData();
        Label label = new Label((Composite)group, 0);
        label.setText("Database id : ");
        label.setLayoutData((Object)gdLabel);
        GridData gdComboDatabaseId = new GridData();
        gdComboDatabaseId.widthHint = 40;
        gdComboDatabaseId.minimumWidth = 40;
        this.comboDatabaseId = new Combo((Composite)group, 2056);
        this.comboDatabaseId.setVisibleItemCount(8);
        this.comboDatabaseId.setLayoutData((Object)gdComboDatabaseId);
        label = new Label((Composite)group, 0);
        label.setText("Database type : ");
        label.setLayoutData((Object)gdLabel);
        GridData gdComboDatabaseType = new GridData();
        gdComboDatabaseType.widthHint = 260;
        gdComboDatabaseType.minimumWidth = 260;
        this.comboDatabaseType = new Combo((Composite)group, 2056);
        this.comboDatabaseType.setVisibleItemCount(12);
        this.comboDatabaseType.setLayoutData((Object)gdComboDatabaseType);
        return group;
    }

    protected void okPressed() {
        PluginLogger.log((Object)this, " ==== OK Pressed ");
        int index = this.comboDatabaseId.getSelectionIndex();
        if (index >= 0) {
            String s = this.comboDatabaseId.getItem(index);
            try {
                this.selectedDatabaseId = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                this.selectedDatabaseId = -1;
            }
        } else {
            this.selectedDatabaseId = -1;
        }
        if ((index = this.comboDatabaseType.getSelectionIndex()) >= 0) {
            String dbTypeName = this.comboDatabaseType.getItem(index);
            this.selectedDatabaseType = DatabaseTypeProvider.getDatabaseTypeByName((String)dbTypeName);
        } else {
            this.selectedDatabaseType = null;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        PluginLogger.log((Object)this, " ==== CANCEL Pressed ");
        super.cancelPressed();
    }

    private void populateDatabaseIdCombo() {
        int n = this.databasesConfigurations.getNumberOfDatabases();
        int max = 10 + n;
        int i = 0;
        while (i < max) {
            if (this.databasesConfigurations.getDatabaseConfiguration(i) == null) {
                this.comboDatabaseId.add("" + i);
            }
            ++i;
        }
        this.comboDatabaseId.select(0);
    }

    private void populateDatabaseTypeCombo() {
        PluginLogger.log((Object)this, "populateDatabaseTypeCombo");
        for (DatabaseType t : DatabaseTypeProvider.getDbTypesList()) {
            this.comboDatabaseType.add(t.getName());
        }
    }

    public int getDatabaseId() {
        return this.selectedDatabaseId;
    }

    public DatabaseType getDatabaseType() {
        return this.selectedDatabaseType;
    }
}

