/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.telosys.tools.eclipse.plugin.commons.FileEditorUtil;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditor;

public class TargetsButton {
    public static final int BUTTON_HEIGHT = 26;
    public static final int BUTTON_WIDTH = 90;
    private final Button _button;
    private final AbstractModelEditor _editor;
    private final IProject _project;

    public TargetsButton(Composite parent, AbstractModelEditor editor, IProject project) {
        this._editor = editor;
        this._project = project;
        this._button = new Button(parent, 0);
        this._button.setToolTipText("Edit templates and resources\ndefined in 'templates.cfg' file");
        this._button.setImage(PluginImages.getImage("TARGETS"));
        this._button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                FileEditorUtil.openTargetsConfigFileInEditor(TargetsButton.this._project, TargetsButton.this._editor.getCurrentBundleName());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    public Button getButton() {
        return this._button;
    }

    public void setEnabled(boolean enabled) {
        this._button.setEnabled(enabled);
    }

    public void addSelectionListener(SelectionListener listener) {
        this._button.addSelectionListener(listener);
    }
}

