/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.telosys.tools.commons.bundles.TargetDefinition;
import org.telosys.tools.eclipse.plugin.commons.FileEditorUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditor;

public class OpenTemplateFileInEditor
implements Listener {
    private final AbstractModelEditor editor;
    private final IProject project;
    private final Table table;
    private final int columnClick;

    public OpenTemplateFileInEditor(AbstractModelEditor editor, IProject project, Table table, int columnClick) {
        this.editor = editor;
        this.project = project;
        this.table = table;
        this.columnClick = columnClick;
    }

    public void handleEvent(Event event) {
        Point pt = new Point(event.x, event.y);
        TableItem item = this.table.getItem(pt);
        if (item == null) {
            return;
        }
        int column = 0;
        int columnCount = this.table.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(pt)) {
                column = i;
            }
            ++i;
        }
        if (column == this.columnClick) {
            Object data = item.getData();
            if (data != null) {
                if (data instanceof TargetDefinition) {
                    TargetDefinition target = (TargetDefinition)item.getData();
                    FileEditorUtil.openTemplateFileInEditor(this.project, this.editor.getCurrentBundleName(), target);
                } else {
                    MsgBox.error("Edit event : this row is not a target instance");
                }
            } else {
                MsgBox.error("Edit event : no data (null)");
            }
        }
    }
}

