/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.telosys.tools.api.TelosysProject;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.bundles.BundlesNames;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditor;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPageForGeneration;

public class BundleComboBox {
    public static final int COMBO_WIDTH = 300;
    public static final int COMBO_HEIGHT = 28;
    private static final int COMBO_VISIBLE_ITEMS = 16;
    private final AbstractModelEditor _editor;
    private final Combo _combo;
    private final AbstractModelEditorPageForGeneration _page;

    public BundleComboBox(Composite parent, AbstractModelEditorPageForGeneration page) {
        this._page = page;
        this._editor = page.getModelEditor();
        this._combo = new Combo(parent, 2056);
        GridData gridData = new GridData(300, 28);
        this._combo.setLayoutData((Object)gridData);
        this._combo.setVisibleItemCount(16);
        this._combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String[] items = BundleComboBox.this._combo.getItems();
                String selectedBundle = items[BundleComboBox.this._combo.getSelectionIndex()];
                if (StrUtil.different((String)selectedBundle, (String)BundleComboBox.this._editor.getCurrentBundleName())) {
                    BundleComboBox.this._editor.setCurrentBundleName(selectedBundle);
                    BundleComboBox.this._page.refreshBundlesAndTargets();
                }
            }
        });
    }

    public void refresh() {
        IProject eclipseProject = this._editor.getProject();
        List<String> bundles = this.getBundlesFromTemplatesFolder(eclipseProject);
        this._combo.removeAll();
        for (String s : bundles) {
            this._combo.add(s);
        }
        String currentBundle = this._editor.getCurrentBundleName();
        if (currentBundle != null) {
            currentBundle = currentBundle.trim();
            int index = 0;
            while (index < this._combo.getItemCount()) {
                if (currentBundle.equals(this._combo.getItem(index))) {
                    this._combo.select(index);
                    break;
                }
                ++index;
            }
        }
    }

    private List<String> getBundlesFromTemplatesFolder(IProject eclipseProject) {
        TelosysProject telosysProject = this._page.getTelosysProject();
        try {
            BundlesNames bundlesNames = telosysProject.getInstalledBundles();
            return bundlesNames.getAll();
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot get installed bundles", e);
            return new LinkedList<String>();
        }
    }
}

