/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.telosys.tools.api.TelosysProject;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractStandardEditor;

public abstract class AbstractStandardEditorPage
extends FormPage {
    private final AbstractStandardEditor _standardEditor;

    public AbstractStandardEditorPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        PluginLogger.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
        if (editor == null) {
            MsgBox.error("FormEditor is null");
        }
        if (editor instanceof AbstractStandardEditor) {
            this._standardEditor = (AbstractStandardEditor)editor;
        } else {
            this._standardEditor = null;
            MsgBox.error("FormEditor is not an instance of StandardEditor");
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.log((Object)this, "createFormContent(..) [ Abstract class ] ...");
        Control pageControl = this.getPartControl();
        if (pageControl == null) {
            MsgBox.error("Page control is null ! Cannot create form content.");
            return;
        }
    }

    public void log(String s) {
        PluginLogger.log(s);
    }

    public void log(Object o, String s) {
        PluginLogger.log(o, s);
    }

    public void setDirty() {
        this._standardEditor.setDirty();
    }

    protected AbstractStandardEditor getStandardEditor() {
        return this._standardEditor;
    }

    public IProject getProject() {
        return this._standardEditor.getProject();
    }

    public TelosysProject getTelosysProject() {
        IProject iProject = this.getProject();
        String projectAbsolutePath = EclipseProjUtil.getAbsolutePathInFileSystem(iProject);
        return new TelosysProject(projectAbsolutePath);
    }

    public TelosysToolsCfg getProjectConfig() {
        return this._standardEditor.getProjectConfig();
    }

    protected Composite initAndGetFormBody(IManagedForm managedForm, Layout layout) {
        ScrolledForm scrolledForm = managedForm.getForm();
        Composite scrolledFormBody = scrolledForm.getBody();
        this.log((Object)this, "- body class = " + scrolledFormBody.getClass());
        Layout currentLayout = scrolledFormBody.getLayout();
        if (currentLayout != null) {
            this.log((Object)this, "- body layout class = " + currentLayout.getClass());
        } else {
            this.log((Object)this, "- body layout class = NO LAYOUT ! ");
        }
        scrolledFormBody.setLayout(layout);
        return scrolledFormBody;
    }
}

