/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.TelosysToolsLogger;
import org.telosys.tools.commons.bundles.BundlesManager;
import org.telosys.tools.commons.bundles.TargetDefinition;
import org.telosys.tools.commons.bundles.TargetsDefinitions;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.commons.logger.ConsoleLogger;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditor;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPage;
import org.telosys.tools.eclipse.plugin.editors.commons.BundleComboBox;
import org.telosys.tools.eclipse.plugin.editors.commons.GenerateButton;
import org.telosys.tools.eclipse.plugin.editors.commons.GridPanel;
import org.telosys.tools.eclipse.plugin.editors.commons.OpenTemplateFileInEditor;
import org.telosys.tools.eclipse.plugin.editors.commons.RefreshButton;
import org.telosys.tools.eclipse.plugin.editors.commons.SelectDeselectButtons;
import org.telosys.tools.eclipse.plugin.editors.commons.TargetsButton;
import org.telosys.tools.eclipse.plugin.editors.dbrep.TargetsUtil;
import org.telosys.tools.eclipse.plugin.editors.dbrep.ToolTipListenerForEntitiesTable;
import org.telosys.tools.eclipse.plugin.editors.dbrep.ToolTipListenerForTargetsTable;
import org.telosys.tools.eclipse.plugin.generator.GenerationTaskWithProgress;
import org.telosys.tools.eclipse.plugin.settings.SettingsManager;
import org.telosys.tools.generic.model.Entity;
import org.telosys.tools.generic.model.Model;

public abstract class AbstractModelEditorPageForGeneration
extends AbstractModelEditorPage {
    private static final int TABLE_HEIGHT = 380;
    private Table _tableEntities = null;
    private Table _tableTargets = null;
    private BundleComboBox _comboBundles = null;
    private Button _checkboxStaticResources = null;
    private List<TargetDefinition> _resourcesTargets = null;

    protected abstract void createEntitiesTableColumns(Table var1);

    protected abstract void populateEntitiesTable(Table var1, List<Entity> var2);

    public AbstractModelEditorPageForGeneration(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.log((Object)this, "createFormContent(IManagedForm) ...");
        ScrolledForm form = managedForm.getForm();
        Composite scrolledFormBody = form.getBody();
        GridLayout formGridLayout = new GridLayout(2, false);
        formGridLayout.marginWidth = 10;
        formGridLayout.verticalSpacing = 0;
        scrolledFormBody.setLayout((Layout)formGridLayout);
        this.createFormCellRow1Col1(scrolledFormBody);
        this.createFormCellRow1Col2(scrolledFormBody);
        this.createFormCellRow2Col1(scrolledFormBody);
        this.createFormCellRow2Col2(scrolledFormBody);
        this.populateEntitiesTable();
        this._comboBundles.refresh();
        this.setBodyBackgroundColor();
        this.log((Object)this, "createFormContent(..) - END.");
    }

    private void createFormCellRow1Col1(Composite formBody) {
        Label labelTitle = Util.setPageTitle(formBody, this.getTitle());
        GridData titleGridData = new GridData(32);
        titleGridData.verticalIndent = 0;
        titleGridData.verticalAlignment = 1;
        titleGridData.horizontalAlignment = 4;
        labelTitle.setLayoutData((Object)titleGridData);
    }

    private void createFormCellRow1Col2(Composite formBody) {
        Composite panelTopRight = new Composite(formBody, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        panelTopRight.setLayout((Layout)gridLayout);
        panelTopRight.setSize(120, 26);
        GridData panelGridData = new GridData();
        panelGridData.verticalAlignment = 1;
        panelGridData.horizontalAlignment = 4;
        panelGridData.verticalIndent = 0;
        panelTopRight.setLayoutData((Object)panelGridData);
        new RefreshButton(panelTopRight, this);
        int fillerWidth = 50;
        this.createFillerInGridLayout(panelTopRight, fillerWidth);
        this._checkboxStaticResources = new Button(panelTopRight, 32);
        this._checkboxStaticResources.setText("Copy static resources");
        this._checkboxStaticResources.setToolTipText("Generation also copy bundle resources \ninto the project (must be done once)");
        this.createFillerInGridLayout(panelTopRight, fillerWidth);
        GenerateButton generateButton = new GenerateButton(panelTopRight);
        generateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (AbstractModelEditorPageForGeneration.this.confirmBulkGeneration()) {
                    Shell shell = Util.cursorWait();
                    AbstractModelEditorPageForGeneration.this.launchBulkGeneration();
                    Util.cursorArrow(shell);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private Label createFillerInGridLayout(Composite composite, int fillerWidth) {
        Label labelFiller = new Label(composite, 0);
        labelFiller.setText("");
        GridData fillerGridData = new GridData();
        fillerGridData.horizontalAlignment = 4;
        fillerGridData.verticalIndent = 0;
        fillerGridData.widthHint = fillerWidth;
        labelFiller.setLayoutData((Object)fillerGridData);
        return labelFiller;
    }

    private void createFormCellRow2Col1(Composite formBody) {
        this.log("createFormCellRow2Col1...");
        Composite panel = new Composite(formBody, 2048);
        panel.setLayout((Layout)new GridLayout(1, false));
        GridData panelGridData = new GridData();
        panelGridData.verticalAlignment = 128;
        panelGridData.horizontalAlignment = 4;
        panel.setLayoutData((Object)panelGridData);
        SelectDeselectButtons buttons = this.createLeftPartHeader(panel);
        this._tableEntities = this.createLeftPartTable(panel);
        buttons.setTable(this._tableEntities);
    }

    private void createFormCellRow2Col2(Composite formBody) {
        Composite panel2 = new Composite(formBody, 2048);
        panel2.setLayout((Layout)new GridLayout(1, false));
        GridData gdpanel2 = new GridData();
        gdpanel2.verticalAlignment = 4;
        gdpanel2.horizontalAlignment = 4;
        panel2.setLayoutData((Object)gdpanel2);
        SelectDeselectButtons selectDeselectButtons = this.createRightPartHeader(panel2);
        this._tableTargets = this.createRightPartTableTargets(panel2);
        GridData gdTableTargets = new GridData();
        gdTableTargets.heightHint = 380;
        gdTableTargets.widthHint = 460;
        this._tableTargets.setLayoutData((Object)gdTableTargets);
        selectDeselectButtons.setTable(this._tableTargets);
    }

    private SelectDeselectButtons createLeftPartHeader(Composite panel) {
        this.log("createLeftPartLine..");
        GridPanel gridPanel = new GridPanel(panel, 2);
        SelectDeselectButtons buttons = new SelectDeselectButtons(gridPanel.getPanel());
        return buttons;
    }

    private Table createLeftPartTable(Composite panel) {
        this.log("createLeftPartLine..");
        Table tableEntities = this.createEntitiesTable(panel);
        GridData gdTableEntities = new GridData();
        gdTableEntities.heightHint = 380;
        gdTableEntities.widthHint = 420;
        tableEntities.setLayoutData((Object)gdTableEntities);
        tableEntities.setToolTipText("");
        ToolTipListenerForEntitiesTable toolTipListener = new ToolTipListenerForEntitiesTable(tableEntities);
        tableEntities.addListener(5, (Listener)toolTipListener);
        tableEntities.addListener(3, (Listener)toolTipListener);
        tableEntities.addListener(4, (Listener)toolTipListener);
        return tableEntities;
    }

    private SelectDeselectButtons createRightPartHeader(Composite panel) {
        this.log("createRightPartLine..");
        GridPanel gridPanel = new GridPanel(panel, 8);
        SelectDeselectButtons buttons2 = new SelectDeselectButtons(gridPanel.getPanel());
        gridPanel.addFiller(30);
        this.log("create BundleComboBox...");
        this._comboBundles = new BundleComboBox(gridPanel.getPanel(), this);
        this.log("BundleComboBox created.");
        gridPanel.addFiller(14);
        new TargetsButton(gridPanel.getPanel(), this.getModelEditor(), this.getProject());
        return buttons2;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.log((Object)this, "init(..,..)...");
        this.log((Object)this, "init(..,..) : site id = '" + site.getId() + "'");
        this.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
    }

    private Table createEntitiesTable(Composite composite) {
        this.log((Object)this, "createTable(..)...");
        int iTableStyle = 101156;
        Table table = new Table(composite, iTableStyle);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.createEntitiesTableColumns(table);
        return table;
    }

    private Table createRightPartTableTargets(Composite composite) {
        this.log((Object)this, "createTableTargetsList(..)...");
        int iTableStyle = 101156;
        Table table = new Table(composite, iTableStyle);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn col = null;
        int iColumnIndex = 0;
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Target");
        col.setWidth(220);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Template");
        col.setWidth(200);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("");
        col.setWidth(20);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("");
        col.setWidth(20);
        table.setToolTipText("");
        ToolTipListenerForTargetsTable tableListener = new ToolTipListenerForTargetsTable(table);
        table.addListener(5, (Listener)tableListener);
        table.addListener(3, (Listener)tableListener);
        table.addListener(4, (Listener)tableListener);
        return table;
    }

    public void newModelNotification() {
        if (this._tableEntities != null) {
            this.populateEntitiesTable();
        }
    }

    private void populateEntitiesTable() {
        this.log((Object)this, "populateEntitiesTable()");
        this._tableEntities.removeAll();
        Model model = this.getModel();
        if (model != null) {
            List entities = model.getEntities();
            this.populateEntitiesTable(this._tableEntities, entities);
        }
    }

    public void refreshBundlesAndTargets() {
        this._comboBundles.refresh();
        String currentBundleName = this.getModelEditor().getCurrentBundleName();
        if (currentBundleName != null) {
            this.refreshAllTargetsTablesFromConfigFile(currentBundleName);
        }
    }

    private void refreshAllTargetsTablesFromConfigFile(String currentBundleName) {
        this.log("refreshAllTargetsTablesFromConfigFile() : current bundle = " + currentBundleName);
        TelosysToolsCfg telosysToolsCfg = this.getProjectConfig();
        if (telosysToolsCfg != null) {
            TargetsDefinitions targetsDefinitions = this.loadTagetsDefinitions(currentBundleName);
            this.refreshTargetsTable(targetsDefinitions.getTemplatesTargets(), targetsDefinitions.getResourcesTargets());
        }
    }

    private TargetsDefinitions loadTagetsDefinitions(String bundleName) {
        BundlesManager bm = new BundlesManager(this.getProjectConfig());
        try {
            return bm.getTargetsDefinitions(bundleName);
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot load targets definitions", e);
            return new TargetsDefinitions();
        }
    }

    private void refreshTargetsTable(List<TargetDefinition> targetslist, List<TargetDefinition> resourcesTargets) {
        this.log("refreshTargetsTable : " + targetslist.size() + " targets / " + (resourcesTargets != null ? String.valueOf(resourcesTargets.size()) + " resources" : "no resource"));
        this._resourcesTargets = resourcesTargets;
        this.populateTargetsTable(targetslist);
        if (this._resourcesTargets.size() > 0) {
            String bundleName = this.getModelEditor().getCurrentBundleName();
            SettingsManager settingsManager = new SettingsManager(this.getProject());
            if (!settingsManager.readBundleStaticResourcesCopiedFlag(bundleName)) {
                this._checkboxStaticResources.setSelection(true);
            } else {
                this._checkboxStaticResources.setSelection(false);
            }
            this._checkboxStaticResources.setEnabled(true);
        } else {
            this._checkboxStaticResources.setSelection(false);
            this._checkboxStaticResources.setEnabled(false);
        }
    }

    private void populateTargetsTable(List<TargetDefinition> list) {
        this.log("populateTargetsTable");
        if (list != null) {
            this._tableTargets.removeAll();
            for (TargetDefinition targetDef : list) {
                this.log((Object)this, " . Target : " + targetDef.getName() + " - " + targetDef.getTemplate());
                TableItem tableItem = new TableItem(this._tableTargets, 0);
                tableItem.setChecked(false);
                tableItem.setImage(null);
                tableItem.setData((Object)targetDef);
                tableItem.setText(0, targetDef.getName());
                if (targetDef.isOnce()) {
                    tableItem.setImage(PluginImages.getImage("FILE1"));
                } else {
                    tableItem.setImage(PluginImages.getImage("FILES"));
                }
                tableItem.setText(1, targetDef.getTemplate());
                tableItem.setImage(2, PluginImages.getImage("EDIT_ICON"));
                tableItem.setText(3, targetDef.isOnce() ? "1" : "*");
            }
        }
        OpenTemplateFileInEditor listener = new OpenTemplateFileInEditor(this.getModelEditor(), this.getProject(), this._tableTargets, 2);
        this._tableTargets.addListener(3, (Listener)listener);
    }

    private boolean confirmBulkGeneration() {
        this.log((Object)this, "confirmBulkGeneration()");
        int numberOfSelectedTargets = 0;
        TableItem[] tableItemArray = this._tableTargets.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                ++numberOfSelectedTargets;
            }
            ++n2;
        }
        if (numberOfSelectedTargets > 0) {
            String sMsg = "This bulk generation will overwrite existing files if they exist.\n\n" + numberOfSelectedTargets + " target(s) selected." + "\n\n" + "Launch generation ?";
            return MsgBox.confirm(" Confirm generation", sMsg);
        }
        if (this._checkboxStaticResources.getSelection()) {
            return true;
        }
        MsgBox.info("Nothing to generate, nothing to copy.");
        return false;
    }

    private LinkedList<TargetDefinition> getSelectedTargets() {
        LinkedList<TargetDefinition> selectedTargets = new LinkedList<TargetDefinition>();
        TargetsUtil.addSelectedItemsToList(selectedTargets, this._tableTargets);
        return selectedTargets;
    }

    private LinkedList<String> getSelectedEntities() {
        LinkedList<String> selectedEntities = new LinkedList<String>();
        int n = this._tableEntities.getItemCount();
        int i = 0;
        while (i < n) {
            TableItem item = this._tableEntities.getItem(i);
            if (item.getChecked()) {
                Object oData = item.getData();
                if (oData != null) {
                    if (oData instanceof String) {
                        String entityName = (String)oData;
                        selectedEntities.addLast(entityName);
                        this.log((Object)this, "getSelectedEntities() : add entity " + entityName);
                    } else {
                        MsgBox.error("Table item " + i + " : invalid Data type");
                    }
                } else {
                    MsgBox.error("Table item " + i + " : no data");
                }
            }
            ++i;
        }
        return selectedEntities;
    }

    private void launchBulkGeneration() {
        this.log("launchBulkGeneration()...");
        LinkedList<String> selectedEntities = this.getSelectedEntities();
        this.log("launchBulkGeneration() : " + selectedEntities.size() + "selected entitie(s)");
        LinkedList<TargetDefinition> selectedTargets = this.getSelectedTargets();
        this.log("launchBulkGeneration() : " + selectedTargets.size() + " selected target(s)");
        List<TargetDefinition> resourcesTargets = null;
        if (this._checkboxStaticResources.getSelection()) {
            resourcesTargets = this._resourcesTargets;
        }
        this.launchBulkGenerationTask(selectedEntities, selectedTargets, resourcesTargets);
        if (resourcesTargets != null) {
            String bundleName = this.getModelEditor().getCurrentBundleName();
            SettingsManager settingsManager = new SettingsManager(this.getProject());
            settingsManager.updateBundleStaticResourcesCopiedFlag(bundleName, true);
            this._checkboxStaticResources.setSelection(false);
        }
    }

    private void launchBulkGenerationTask(LinkedList<String> selectedEntities, LinkedList<TargetDefinition> selectedTargets, List<TargetDefinition> resourcesTargets) {
        AbstractModelEditor editor = this.getModelEditor();
        TelosysToolsCfg telosysToolsCfg = this.getProjectConfig();
        String bundleName = editor.getCurrentBundleName();
        TelosysToolsLogger telosysToolsLogger = editor.getLogger() != null ? editor.getLogger() : new ConsoleLogger();
        GenerationTaskWithProgress generationTaskWithProgress = null;
        try {
            generationTaskWithProgress = new GenerationTaskWithProgress(editor.getModel(), selectedEntities, bundleName, selectedTargets, resourcesTargets, telosysToolsCfg, telosysToolsLogger);
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot create GenerationTaskWithProgress", e);
        }
        if (generationTaskWithProgress != null) {
            generationTaskWithProgress.launch();
        }
    }

    private boolean hasWarnings(Entity entity) {
        return entity.getWarnings() != null && entity.getWarnings().size() > 0;
    }

    protected Image getEntityWarningImage(Entity entity) {
        if (this.hasWarnings(entity)) {
            return PluginImages.getImage("WARNING");
        }
        return null;
    }
}

