/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.ModelUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPageForGeneration;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractStandardEditor;
import org.telosys.tools.generic.model.Model;
import org.telosys.tools.repository.model.RepositoryModel;

public abstract class AbstractModelEditor
extends AbstractStandardEditor {
    private Model _model = null;
    private String _currentBundle = null;
    private AbstractModelEditorPageForGeneration _codeGenerationPage = null;

    protected abstract Model loadModel(File var1);

    protected abstract void saveModel(Model var1, File var2);

    protected void setCodeGenerationPage(AbstractModelEditorPageForGeneration codeGenerationPage) {
        this._codeGenerationPage = codeGenerationPage;
    }

    public Model getModel() {
        return this._model;
    }

    protected void setModel(Model model) {
        this.log((Object)this, "setModel(Model)...");
        this._model = model;
        if (this._codeGenerationPage != null) {
            this._codeGenerationPage.newModelNotification();
        }
    }

    public RepositoryModel getRepositoryModel() {
        if (this._model != null) {
            try {
                return ModelUtil.toRepositoryModel(this._model);
            }
            catch (Exception e) {
                MsgBox.error("Cannot convert current model to Database Model", e);
            }
        } else {
            MsgBox.error("Cannot get Database Model, current model is null");
        }
        return null;
    }

    public void setCurrentBundleName(String bundleName) {
        this._currentBundle = bundleName;
    }

    public String getCurrentBundleName() {
        return this._currentBundle;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.log((Object)this, "init(..,..)...");
        super.init(site, input);
    }

    public File getModelFile() {
        return EclipseWksUtil.toFile(this.getFile());
    }

    public void loadModel() {
        this.log((Object)this, "loadModel()...");
        File file = this.getModelFile();
        Model model = this.loadModel(file);
        this.setModel(model);
    }

    public void doSave(IProgressMonitor monitor) {
        this.log((Object)this, "doSave()...");
        monitor.beginTask("Saving the model...", -1);
        File modelFile = this.getModelFile();
        this.saveModel(this.getModel(), modelFile);
        super.setDirty(false);
        super.refreshFile(monitor);
        monitor.done();
    }

    public void doSaveAs() {
        MsgBox.error("'Save as' is not allowed");
    }

    public boolean isSaveAsAllowed() {
        this.log((Object)this, "isSaveAsAllowed()...");
        return false;
    }
}

