/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.config.view;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.commons.bundles.BundlesFromGitHub;
import org.telosys.tools.commons.bundles.BundlesManager;
import org.telosys.tools.commons.bundles.BundlesNames;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;

public class PopulateListTaskWithProgress
implements IRunnableWithProgress {
    private final String account;
    private final List swtListOfBundles;
    private final TelosysToolsCfg telosysToolsCfg;
    private final Text loggerTextArea;

    public PopulateListTaskWithProgress(TelosysToolsCfg telosysToolsCfg, String sGitHubUserName, List swtListToBePopulated, Text loggerTextArea) {
        this.telosysToolsCfg = telosysToolsCfg;
        this.account = sGitHubUserName;
        this.swtListOfBundles = swtListToBePopulated;
        this.loggerTextArea = loggerTextArea;
    }

    private BundlesFromGitHub getGitHubBundles() {
        BundlesManager bm = new BundlesManager(this.telosysToolsCfg);
        BundlesFromGitHub bundlesFromGitHub = null;
        try {
            bundlesFromGitHub = bm.getGitHubBundlesList(this.account);
        }
        catch (Exception e) {
            bundlesFromGitHub = null;
            MsgBox.error("Cannot get bundles from GitHub", e);
        }
        return bundlesFromGitHub;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        int totalWorkTasks = 3;
        progressMonitor.beginTask("Requesting GitHub server ...", totalWorkTasks);
        progressMonitor.worked(1);
        this.loggerTextArea.setText("");
        this.swtListOfBundles.removeAll();
        this.loggerTextArea.append("Requesting GitHub...\n");
        BundlesFromGitHub bundlesFromGitHub = this.getGitHubBundles();
        progressMonitor.worked(2);
        this.loggerTextArea.append("GitHub response received.\n");
        if (bundlesFromGitHub != null) {
            int httpStatusCode = bundlesFromGitHub.getHttpStatusCode();
            this.loggerTextArea.append(" Http Status = " + httpStatusCode + "\n");
            this.loggerTextArea.append(" GitHub API rate limit : remaining " + bundlesFromGitHub.getRemaining() + " / " + bundlesFromGitHub.getLimit() + "\n");
            this.loggerTextArea.append(" GitHub API reset : " + bundlesFromGitHub.getReset() + "\n");
            if (httpStatusCode == 200) {
                BundlesNames bundleNames = bundlesFromGitHub.getBundlesNames();
                for (String s : bundleNames.getAll()) {
                    this.swtListOfBundles.add(s);
                }
            } else if (httpStatusCode == 403) {
                StringBuffer sb = new StringBuffer();
                sb.append("Cannot get bundles from GitHub.");
                sb.append("\n");
                sb.append("\n GitHub API http status '403 Forbidden'");
                sb.append("\n");
                sb.append("\n GitHub API rate limit status : ");
                sb.append("\n  . remaining : " + bundlesFromGitHub.getRemaining());
                sb.append("\n  . limit     : " + bundlesFromGitHub.getLimit());
                sb.append("\n  . reset     : " + bundlesFromGitHub.getReset());
                MsgBox.error(sb.toString());
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("Cannot get bundles from GitHub, unexpected http status code");
                sb.append("\n");
                sb.append("\n GitHub API http status '" + httpStatusCode + "'");
                MsgBox.error(sb.toString());
            }
        }
        progressMonitor.done();
    }
}

