/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons.unused;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;

class ClassChooser {
    Shell _parentShell = null;
    Shell _windowShell = null;
    Button _buttonOk = null;
    IJavaProject _javaProject = null;
    ICompilationUnit _selectedClass = null;

    public ClassChooser(Shell parentShell, IJavaProject javaProject) {
        this._parentShell = parentShell;
        this._javaProject = javaProject;
    }

    public void open() {
        if (this._windowShell == null) {
            this.createWindow();
        }
        this.show();
        this._selectedClass = null;
    }

    public void show() {
        if (this._windowShell != null) {
            this._windowShell.setVisible(true);
        }
        this._windowShell.setActive();
    }

    public void hide() {
        if (this._windowShell != null) {
            this._windowShell.setVisible(false);
        }
    }

    public void close() {
        if (this._windowShell != null) {
            this._windowShell.dispose();
        }
        this._windowShell = null;
    }

    public ICompilationUnit getSelected() {
        return this._selectedClass;
    }

    private void createButtonOK(Composite panel) {
        this._buttonOk = new Button(panel, 8);
        this._buttonOk.setText("Ok");
        this._buttonOk.setEnabled(false);
        this._buttonOk.setLayoutData((Object)new GridData(768));
        this._buttonOk.addSelectionListener(this.getButtonOkEvents());
    }

    private void createButtonCancel(Composite panel) {
        Button button = new Button(panel, 8);
        button.setText("Cancel");
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener(this.getButtonCancelEvents());
    }

    private Tree createTreePanel(Shell shell) {
        Composite panel = new Composite((Composite)shell, 2048);
        panel.setLayout((Layout)new GridLayout());
        panel.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(panel, 0);
        tree.setToolTipText("Select a class");
        tree.setLayoutData((Object)new GridData(1808));
        tree.addSelectionListener(this.getTreeEvents());
        return tree;
    }

    private void createButtonsPanel(Shell shell) {
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(768));
        this.createButtonOK(panel);
        this.createButtonCancel(panel);
    }

    private void createWindow() {
        Shell shell = new Shell(this._parentShell, 67648);
        shell.setText("Class browser");
        shell.setLocation(new Point(450, 200));
        shell.setSize(400, 400);
        shell.setLayout((Layout)new GridLayout());
        shell.setLayoutData((Object)new GridData(768));
        this._windowShell = shell;
        Tree tree = this.createTreePanel(shell);
        this.createButtonsPanel(shell);
        try {
            this.populateTree(tree);
        }
        catch (JavaModelException e) {
            MsgBox.error("Cannot populate tree from JavaProject ! \n JavaModelException : " + (Object)((Object)e));
        }
    }

    private void populateTree(Tree tree) throws JavaModelException {
        IPackageFragmentRoot[] packages = this._javaProject.getPackageFragmentRoots();
        boolean bUseIt = false;
        int i = 0;
        while (i < packages.length) {
            IPackageFragmentRoot pfr = packages[i];
            bUseIt = true;
            if (pfr.isArchive()) {
                bUseIt = false;
            }
            if (pfr.isExternal()) {
                bUseIt = false;
            }
            if (bUseIt) {
                this.addPackageFragmentRoot(tree, pfr);
            }
            ++i;
        }
    }

    private void addPackageFragmentRoot(Tree tree, IPackageFragmentRoot pfr) throws JavaModelException {
        String sName = pfr.getElementName();
        if (sName != null) {
            if (sName.trim().length() == 0) {
                sName = "(default src dir)";
            }
        } else {
            MsgBox.error("PackageFragmentRoot name is null !");
            return;
        }
        TreeItem item = new TreeItem(tree, 0);
        item.setText(sName);
        IJavaElement[] javaElements = pfr.getChildren();
        int i = 0;
        while (i < javaElements.length) {
            if (!(javaElements[i] instanceof IPackageFragment)) {
                MsgBox.error("IPackageFragmentRoot child [" + i + "] is not an instance of IPackageFragment !");
                return;
            }
            IPackageFragment pkg = (IPackageFragment)javaElements[i];
            this.addPackageFragment(item, pkg);
            ++i;
        }
        item.setExpanded(true);
    }

    private void addPackageFragment(TreeItem treeItem, IPackageFragment pkg) throws JavaModelException {
        if (!pkg.hasChildren()) {
            return;
        }
        String sPackageName = pkg.getElementName();
        if (sPackageName != null) {
            if (sPackageName.trim().length() == 0) {
                sPackageName = "(default package)";
            }
        } else {
            MsgBox.error("PackageFragment name is null !");
            return;
        }
        TreeItem item = new TreeItem(treeItem, 0);
        item.setText(sPackageName);
        IJavaElement[] javaElements = pkg.getChildren();
        int i = 0;
        while (i < javaElements.length) {
            if (!(javaElements[i] instanceof ICompilationUnit)) {
                MsgBox.error("IPackageFragment child [" + i + "] is not an instance of ICompilationUnit !");
                return;
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)javaElements[i];
            this.addClass(item, compilationUnit);
            ++i;
        }
    }

    private void addClass(TreeItem treeItem, ICompilationUnit compilationUnit) throws JavaModelException {
        TreeItem item = new TreeItem(treeItem, 0);
        IType type = compilationUnit.findPrimaryType();
        if (type != null) {
            item.setText(type.getElementName());
        } else {
            item.setText(String.valueOf(compilationUnit.getElementName()) + " ( no primary type )");
        }
        item.setData((Object)compilationUnit);
    }

    protected void printPackagesFragRoots() throws JavaModelException {
        IPackageFragmentRoot[] packages = this._javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < packages.length) {
            String s = "";
            IPackageFragmentRoot p = packages[i];
            if (p.isArchive()) {
                s = String.valueOf(s) + "ARCHIVE ";
            }
            if (p.isExternal()) {
                s = String.valueOf(s) + "EXTERNAL ";
            }
            if (p.isReadOnly()) {
                s = String.valueOf(s) + "READ-ONLY ";
            }
            MsgBox.info("Package root [" + i + "] : " + p.getElementName() + " : " + s);
            ++i;
        }
    }

    private final SelectionListener getButtonOkEvents() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ClassChooser.this.close();
            }
        };
    }

    private final SelectionListener getButtonCancelEvents() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ClassChooser.this.close();
            }
        };
    }

    private final SelectionListener getTreeEvents() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MsgBox.info("TREE : widgetDefaultSelected");
            }

            public void widgetSelected(SelectionEvent e) {
                ICompilationUnit compilationUnit;
                Widget widget = e.item;
                if (!(widget instanceof TreeItem)) {
                    MsgBox.error("Event widget is not a TreeItem");
                    return;
                }
                TreeItem item = (TreeItem)widget;
                Object oData = item.getData();
                if (oData == null) {
                    ClassChooser.this._buttonOk.setEnabled(false);
                    return;
                }
                if (!(oData instanceof ICompilationUnit)) {
                    MsgBox.error("TreeItem data is not a ICompilationUnit");
                    ClassChooser.this._buttonOk.setEnabled(false);
                    return;
                }
                ClassChooser.this._selectedClass = compilationUnit = (ICompilationUnit)oData;
                ClassChooser.this._buttonOk.setEnabled(true);
            }
        };
    }
}

