/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons.mapping;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.widgets.Text;

public class MapperTextBean<T> {
    private static final String ERROR_SEARCH_SETTER = "Cannot get setter method ";
    private static final String ERROR_INVOKE_SETTER = "Cannot invoke setter ";
    private final Text text;
    private final Class<T> beanClass;
    private final String methodName;
    private final Class<?> propertyType;
    private Method method;

    public MapperTextBean(Text text, Class<T> beanClass, String methodName, Class<?> propertyType) {
        if (text == null) {
            throw new IllegalArgumentException("Text is null");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("Class is null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Method name is null");
        }
        this.text = text;
        this.beanClass = beanClass;
        this.methodName = methodName.trim();
        this.propertyType = propertyType;
        Class[] arguments = new Class[]{propertyType};
        try {
            this.method = beanClass.getMethod(this.methodName, arguments);
        }
        catch (SecurityException e) {
            throw new RuntimeException(ERROR_SEARCH_SETTER + methodName + "(SecurityException)", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(ERROR_SEARCH_SETTER + methodName + "(NoSuchMethodException)", e);
        }
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void updateBean(T bean) throws Exception {
        Object[] params = new Object[1];
        if (String.class.equals(this.propertyType)) {
            params[0] = this.text.getText();
        } else if (Integer.TYPE.equals(this.propertyType)) {
            params[0] = this.toInt(this.text.getText());
        } else {
            throw new Exception("Type '" + this.propertyType.getName() + "' not supported");
        }
        try {
            this.method.invoke(bean, params);
        }
        catch (IllegalArgumentException e) {
            throw new Exception(ERROR_INVOKE_SETTER + this.methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new Exception(ERROR_INVOKE_SETTER + this.methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new Exception(ERROR_INVOKE_SETTER + this.methodName, e);
        }
    }

    private int toInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

