/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons.listeners;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractListenerForTableToolTip
implements Listener {
    private final Table table;
    private Shell tip = null;
    private TableItem currentTableItem = null;
    private Point currentPoint = null;

    public AbstractListenerForTableToolTip(Table table) {
        this.table = table;
    }

    protected abstract String getToolTipInfo(TableItem var1);

    private void log(String msg) {
    }

    private void logEvent(Event event) {
        String msg = "???";
        switch (event.type) {
            case 12: {
                msg = "Dispose";
                break;
            }
            case 5: {
                msg = "MouseMove";
                break;
            }
            case 32: {
                msg = "MouseHover";
                break;
            }
            case 3: {
                msg = "MouseDown";
                break;
            }
            case 4: {
                msg = "MouseUp";
            }
        }
        this.log("Event '" + msg + "' : " + event);
    }

    public void handleEvent(Event event) {
        this.logEvent(event);
        TableItem tableItem = this.getTableItem(event);
        if (event.type == 3) {
            if (tableItem != null) {
                this.log("table location     : " + this.table.getLocation());
                this.log("table size         : " + this.table.getSize());
                this.log("table header hight : " + this.table.getHeaderHeight());
                if (event.x > 30 && event.x < this.table.getSize().x - 80 && event.y > this.table.getHeaderHeight() + 3) {
                    this.showToolTip(event, tableItem);
                }
            }
        } else if (event.type == 4) {
            this.disposeToolTip();
        } else if (event.type == 5) {
            if (tableItem == null || tableItem != this.currentTableItem) {
                this.disposeToolTip();
            } else if (this.deltaXY(event, 2)) {
                this.disposeToolTip();
            }
        }
    }

    private boolean deltaXY(Event event, int deltaMax) {
        int delta = this.currentPoint.x - event.x;
        if (delta > deltaMax || delta < -deltaMax) {
            return true;
        }
        delta = this.currentPoint.y - event.y;
        return delta > deltaMax || delta < -deltaMax;
    }

    private TableItem getTableItem(Event event) {
        TableItem tableItem = this.table.getItem(new Point(event.x, event.y));
        this.log("getTableItem : " + tableItem);
        return tableItem;
    }

    private void showToolTip(Event event, TableItem tableItem) {
        this.log("showToolTip()");
        if (tableItem == null) {
            return;
        }
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.currentTableItem = tableItem;
        this.currentPoint = new Point(event.x, event.y);
        String info = this.getToolTipInfo(tableItem);
        if (info == null) {
            info = "( no tool tip information )";
        }
        Shell shell = this.table.getShell();
        Display display = shell.getDisplay();
        Color foregroundColor = display.getSystemColor(28);
        Color backgroundColor = display.getSystemColor(29);
        this.tip = new Shell(shell, 16388);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 8;
        fillLayout.marginHeight = 3;
        this.tip.setLayout((Layout)fillLayout);
        this.tip.setForeground(foregroundColor);
        this.tip.setBackground(backgroundColor);
        Label label = new Label((Composite)this.tip, 0);
        label.setForeground(foregroundColor);
        label.setBackground(backgroundColor);
        label.setText(info);
        Point size = this.tip.computeSize(-1, -1);
        Rectangle rect = tableItem.getBounds(0);
        Point pt = this.table.toDisplay(rect.x, rect.y);
        this.tip.setBounds(pt.x + 20, pt.y + 20, size.x, size.y);
        this.tip.setVisible(true);
    }

    private void disposeToolTip() {
        this.log("disposeToolTip()");
        if (this.tip != null) {
            this.tip.dispose();
        }
        this.tip = null;
    }
}

