/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.telosys.tools.commons.variables.Variable;
import org.telosys.tools.eclipse.plugin.commons.ITableItem;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.config.view.VariableItem;

public abstract class GenericEditableTable
extends Composite {
    private TableViewer tableViewer;
    private SelectionAdapter addSelectionAdapter = new AddSelectionAdapter(this);
    private SelectionAdapter insertSelectionAdapter = new InsertSelectionAdapter(this);
    private SelectionAdapter deleteSelectionAdapter = new DeleteSelectionAdapter(this);

    public GenericEditableTable(Composite parent, int swtCompositeFlags) {
        super(parent, swtCompositeFlags);
        FillLayout compositeLayout = new FillLayout();
        this.setLayout((Layout)compositeLayout);
        Table table = new Table((Composite)this, 65536);
        this.initTable(table);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new StructuredContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProviderImpl());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifierImpl(this.tableViewer));
        this.initTableViewer(this.tableViewer);
    }

    protected abstract void initTable(Table var1);

    protected abstract void initTableViewer(TableViewer var1);

    public abstract Object getNewItem();

    public SelectionAdapter getAddSelectionAdapter() {
        return this.addSelectionAdapter;
    }

    public SelectionAdapter getInsertSelectionAdapter() {
        return this.insertSelectionAdapter;
    }

    public SelectionAdapter getDeleteSelectionAdapter() {
        return this.deleteSelectionAdapter;
    }

    public void initItems(Object[] items) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Object o = items[i];
                if (o instanceof Variable) {
                    VariableItem item = new VariableItem((Variable)o);
                    this.tableViewer.add((Object)item);
                } else {
                    MsgBox.error("initItems : item " + i + " is not an instance of Variable !");
                }
                ++i;
            }
        }
    }

    public void addItem() {
        Object item = this.getNewItem();
        this.tableViewer.add(item);
        int lastRow = this.tableViewer.getTable().getItemCount() - 1;
        this.tableViewer.getTable().select(lastRow);
        this.tableViewer.getTable().setFocus();
    }

    public void removeItem() {
        int selectedRow = this.tableViewer.getTable().getSelectionIndex();
        if (selectedRow >= 0) {
            this.tableViewer.remove(this.tableViewer.getElementAt(selectedRow));
            int nbRows = this.tableViewer.getTable().getItemCount();
            if (nbRows > 0) {
                if (selectedRow < nbRows) {
                    this.tableViewer.getTable().select(selectedRow);
                } else {
                    this.tableViewer.getTable().select(nbRows - 1);
                }
            }
            this.tableViewer.getTable().setFocus();
        }
    }

    public void insertItem() {
        int selectedRow = this.tableViewer.getTable().getSelectionIndex();
        if (selectedRow >= 0) {
            Object item = this.getNewItem();
            this.tableViewer.insert(item, selectedRow);
            this.tableViewer.getTable().select(selectedRow);
            this.tableViewer.getTable().setFocus();
        }
    }

    public Object[] getItems() {
        int nbItem = this.tableViewer.getTable().getItemCount();
        Object[] items = new Object[nbItem];
        int i = 0;
        while (i < nbItem) {
            items[i] = this.tableViewer.getElementAt(i);
            ++i;
        }
        return items;
    }

    private class AddSelectionAdapter
    extends SelectionAdapter {
        GenericEditableTable table = null;

        AddSelectionAdapter(GenericEditableTable table) {
            this.table = table;
        }

        public void widgetSelected(SelectionEvent e) {
            this.table.addItem();
        }
    }

    private class CellModifierImpl
    implements ICellModifier {
        private TableViewer tableViewer;

        public CellModifierImpl(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public boolean canModify(Object item, String property) {
            return true;
        }

        public Object getValue(Object item, String property) {
            if (item instanceof ITableItem) {
                return ((ITableItem)item).getValue(property);
            }
            MsgBox.error("CellModifierImpl - getValue : \n item data does not implements ITableItem \n data class : " + item.getClass().getName());
            return null;
        }

        public void modify(Object item, String property, Object value) {
            if (item instanceof TableItem) {
                Object data = ((TableItem)item).getData();
                if (data instanceof ITableItem) {
                    ((ITableItem)data).setValue(property, value);
                    this.tableViewer.refresh(data);
                } else {
                    MsgBox.error("CellModifierImpl - modify : \n item data does not implements ITableItem \n data class : " + data.getClass().getName());
                }
            } else if (item instanceof ITableItem) {
                ((ITableItem)item).setValue(property, value);
                this.tableViewer.refresh(item);
            } else {
                MsgBox.error("CellModifierImpl - modify : \n item is not a TableItem \n item class : " + item.getClass().getName());
            }
        }
    }

    private class DeleteSelectionAdapter
    extends SelectionAdapter {
        GenericEditableTable table = null;

        DeleteSelectionAdapter(GenericEditableTable table) {
            this.table = table;
        }

        public void widgetSelected(SelectionEvent e) {
            this.table.removeItem();
        }
    }

    private class InsertSelectionAdapter
    extends SelectionAdapter {
        GenericEditableTable table = null;

        InsertSelectionAdapter(GenericEditableTable table) {
            this.table = table;
        }

        public void widgetSelected(SelectionEvent e) {
            this.table.insertItem();
        }
    }

    private class StructuredContentProvider
    implements IStructuredContentProvider {
        private StructuredContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProviderImpl
    implements ITableLabelProvider {
        private TableLabelProviderImpl() {
        }

        public Image getColumnImage(Object item, int columnIndex) {
            return null;
        }

        public String getColumnText(Object item, int columnIndex) {
            if (item instanceof ITableItem) {
                return ((ITableItem)item).getColumnText(columnIndex);
            }
            MsgBox.error("ITableLabelProvider : item does not implement ITableItem ");
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener lpl) {
        }
    }
}

