/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public class MyPlugin {
    private static final String IMAGES_PLUGIN_FOLDER = "icons";
    private static final String RESOURCES_PLUGIN_FOLDER = "resources";
    private static String $sPluginId = "(no-id)";
    private static String $sPluginName = "(no-name)";
    private static String $sPluginVersion = "(no-version)";
    private static String $sPluginProvider = "(no-provider)";
    private static Bundle $bundle = null;

    protected static void init(Bundle bundle) {
        if (bundle == null) {
            MsgBox.error("Plugin.init() : bundle argument is null !");
            return;
        }
        PluginLogger.log("Plugin.init() ... ");
        $bundle = bundle;
        $sPluginId = bundle.getSymbolicName();
        PluginLogger.log(" Plugin ID = " + $sPluginId);
        Dictionary dict = bundle.getHeaders();
        if (dict != null) {
            Object o = null;
            o = dict.get("Bundle-Name");
            if (o instanceof String) {
                $sPluginName = o;
            }
            PluginLogger.log(" Plugin name = " + $sPluginName);
            o = dict.get("Bundle-Version");
            if (o instanceof String) {
                $sPluginVersion = o;
            }
            PluginLogger.log(" Plugin version = " + $sPluginVersion);
            o = dict.get("Bundle-Vendor");
            if (o instanceof String) {
                $sPluginProvider = o;
            }
            PluginLogger.log(" Plugin provider = " + $sPluginProvider);
        } else {
            PluginLogger.log(" No bundle headers ( return is null )");
        }
        PluginLogger.log(" Plugin base URL = " + MyPlugin.getBaseURL());
        PluginLogger.log(" Plugin directory URL = " + MyPlugin.getBaseURLAsString());
        PluginLogger.log(" Plugin directory = " + MyPlugin.getDirectory());
        PluginLogger.log(" Plugin icons directory     = " + MyPlugin.getImagesDirectory());
        PluginLogger.log(" Plugin resources directory = " + MyPlugin.getResourcesDirectory());
    }

    protected static void logBundle(Bundle bundle) {
        PluginLogger.log(" bundle.getBundleId() : " + bundle.getBundleId());
        PluginLogger.log(" bundle.getLocation() : " + bundle.getLocation());
        PluginLogger.log(" bundle.getSymbolicName() : " + bundle.getSymbolicName());
        try {
            Dictionary dict = bundle.getHeaders();
            PluginLogger.log(" after bundle.getHeaders() ");
            if (dict != null) {
                Enumeration en = dict.keys();
                PluginLogger.log(" after dict.keys() ");
                if (en != null) {
                    Object oKey = null;
                    Object oVal = null;
                    while (en.hasMoreElements()) {
                        oKey = en.nextElement();
                        oVal = dict.get(oKey);
                        PluginLogger.log("  . " + oKey + " : " + oVal);
                    }
                } else {
                    PluginLogger.log(" No enumeration ( return is null )");
                }
            } else {
                PluginLogger.log(" No bundle headers ( return is null )");
            }
        }
        catch (Throwable e) {
            PluginLogger.log(" Exception : " + e.toString() + " " + e.getMessage());
        }
    }

    public static String getId() {
        return $sPluginId;
    }

    public static String getName() {
        return $sPluginName;
    }

    public static String getVersion() {
        return $sPluginVersion;
    }

    public static String getProvider() {
        return $sPluginProvider;
    }

    public static Bundle getBundle() {
        return $bundle;
    }

    private static URL getBaseURL() {
        URL resolvedUrl = null;
        if ($bundle != null) {
            URL pluginRelativeUrl = FileLocator.find((Bundle)$bundle, (IPath)new Path(""), null);
            if (pluginRelativeUrl != null) {
                try {
                    resolvedUrl = FileLocator.resolve((URL)pluginRelativeUrl);
                }
                catch (IOException e) {
                    MsgBox.error("Cannot resolve relative URL '" + pluginRelativeUrl + "' !", e);
                }
            } else {
                MsgBox.error("Cannot get plugin directory : Platform.find() return null !");
            }
        } else {
            MsgBox.error("Cannot get plugin directory ( bundle is null ) !");
        }
        return resolvedUrl;
    }

    public static String getBaseURLAsString() {
        URL url = MyPlugin.getBaseURL();
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    public static String getDirectory() {
        String sPluginDirectoryURL = MyPlugin.getBaseURLAsString();
        if (sPluginDirectoryURL != null) {
            if (sPluginDirectoryURL.startsWith("file:/")) {
                return sPluginDirectoryURL.substring(6);
            }
            return sPluginDirectoryURL;
        }
        return null;
    }

    public static String getImagesDirectory() {
        String sPluginDir = MyPlugin.getDirectory();
        if (sPluginDir != null) {
            return String.valueOf(sPluginDir) + IMAGES_PLUGIN_FOLDER;
        }
        return null;
    }

    public static String getResourcesDirectory() {
        String sPluginDir = MyPlugin.getDirectory();
        if (sPluginDir != null) {
            return String.valueOf(sPluginDir) + RESOURCES_PLUGIN_FOLDER;
        }
        return null;
    }

    public static URL getImageURL(String sImageFile) {
        URL imageURL = null;
        URL baseURL = MyPlugin.getBaseURL();
        if (baseURL != null) {
            try {
                imageURL = new URL(baseURL, "icons/" + sImageFile);
            }
            catch (MalformedURLException e) {
                MsgBox.error("Cannot get image URL for '" + sImageFile + "'.", e);
            }
        }
        return imageURL;
    }
}

